/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ResourceLoader {
    private ResourceBundle m_bundle = null;

    ResourceLoader() {
    }

    public void setResourceName(String name) {
        if (this.m_bundle == null) {
            try {
                this.m_bundle = ResourceBundle.getBundle(name);
            }
            catch (MissingResourceException e) {
                Trace.log(2, e);
            }
        }
    }

    public String getString(String key) {
        if (this.m_bundle != null) {
            try {
                return this.m_bundle.getString(key);
            }
            catch (MissingResourceException e) {
                Trace.log(2, e);
                try {
                    return MessageFormat.format(this.m_bundle.getString("MISSING_KEY"), key);
                }
                catch (Exception eAgain) {
                    return "RESOURCE BUNDLE ERROR.";
                }
            }
        }
        return "RESOURCE BUNDLE ERROR.";
    }

    public String getStringWithNoSubstitute(String key) {
        if (this.m_bundle != null) {
            try {
                return this.m_bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        return null;
    }
}

