/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class DateFieldDescription
extends FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    static HashSet formatsWithFixedSeparators_;
    private String dateFormat_ = null;
    private String dateSeparator_ = null;

    public DateFieldDescription() {
    }

    public DateFieldDescription(AS400Text dataType, String name) {
        super(dataType, name);
    }

    public DateFieldDescription(AS400Text dataType, String name, String ddsName) {
        super(dataType, name, ddsName);
    }

    public DateFieldDescription(AS400Date dataType, String name) {
        super(dataType, name);
    }

    public DateFieldDescription(AS400Date dataType, String name, String ddsName) {
        super(dataType, name, ddsName);
    }

    public String getDATFMT() {
        return this.dateFormat_ == null ? "" : this.dateFormat_;
    }

    public String getDATSEP() {
        return this.dateSeparator_ == null ? "" : this.dateSeparator_;
    }

    @Override
    String[] getDDSDescription() {
        Vector<String> v = new Vector<String>();
        StringBuffer desc = new StringBuffer(this.ddsName_);
        while (desc.length() < 10) {
            desc.append(" ");
        }
        if (!this.refFld_.equals("")) {
            desc.append("R");
        } else {
            desc.append(" ");
        }
        desc.append("     ");
        desc.append("L");
        desc.append("  ");
        desc.append("       ");
        v.addElement(desc.toString());
        String[] keywords = super.getFieldFunctions();
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                v.addElement(keywords[i]);
            }
        }
        if (this.dateFormat_ != null) {
            v.addElement("DATFMT(" + this.dateFormat_ + ") ");
        }
        if (this.dateSeparator_ != null) {
            if (!DateFieldDescription.formatHasFixedSeparator(this.dateFormat_)) {
                v.addElement("DATSEP('" + this.dateSeparator_ + "') ");
            } else if (Trace.traceOn_) {
                Trace.log(1, "DDS date format " + this.dateFormat_ + " has a fixed separator.");
            }
        }
        if (this.defaultValue_ != null) {
            v.addElement("DFT('" + this.defaultValue_.toString() + "') ");
        } else if (this.isDFTNull_) {
            v.addElement("DFT(*NULL) ");
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    static boolean formatHasFixedSeparator(String format) {
        return DateFieldDescription.getFormatsWithFixedSeparators().contains(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashSet getFormatsWithFixedSeparators() {
        if (formatsWithFixedSeparators_ != null) return formatsWithFixedSeparators_;
        Class<DateFieldDescription> clazz = DateFieldDescription.class;
        synchronized (DateFieldDescription.class) {
            if (formatsWithFixedSeparators_ != null) return formatsWithFixedSeparators_;
            formatsWithFixedSeparators_ = new HashSet(6);
            formatsWithFixedSeparators_.add("*ISO");
            formatsWithFixedSeparators_.add("*USA");
            formatsWithFixedSeparators_.add("*EUR");
            formatsWithFixedSeparators_.add("*JIS");
            // ** MonitorExit[var0] (shouldn't be in output)
            return formatsWithFixedSeparators_;
        }
    }

    public void setDataType(AS400Text dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = dataType.getByteLength();
    }

    public void setDataType(AS400Date dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = dataType.getByteLength();
    }

    public void setDATFMT(String dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat");
        }
        this.dateFormat_ = dateFormat.startsWith("*") ? dateFormat.toUpperCase() : "*" + dateFormat.toUpperCase();
        if (this.dataType_ instanceof AS400Date) {
            ((AS400Date)this.dataType_).setFormat(dateFormat);
        }
    }

    public void setDATSEP(String separator) {
        if (this.dataType_ instanceof AS400Date) {
            if (separator != null && separator.length() > 1) {
                throw new ExtendedIllegalArgumentException("separator (" + separator + ")", 1);
            }
            Character sep = separator == null ? null : Character.valueOf(separator.charAt(0));
            ((AS400Date)this.dataType_).setSeparator(sep);
        }
        this.dateSeparator_ = separator;
    }

    public void setDFT(String defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTCurrent() {
        this.isDFTCurrent_ = true;
        this.isDFTNull_ = false;
        this.defaultValue_ = null;
        this.DFTCurrentValue_ = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }
}

