/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.transforms.exectests;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.transforms.exectests.ExecuteTestsMeta;
import org.apache.hop.testing.util.DataSetConst;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExecuteTestsDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ExecuteTestsDialog.class;
    private ExecuteTestsMeta input;
    private Combo wTestNameInputField;
    private Combo wTypeToExecute;
    private TextVar wPipelineNameField;
    private TextVar wUnitTestNameField;
    private TextVar wDataSetNameField;
    private TextVar wTransformNameField;
    private TextVar wErrorField;
    private TextVar wCommentField;
    private boolean hasPreviousTransforms;

    public ExecuteTestsDialog(Shell parent, IVariables variables, ExecuteTestsMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        String[] inputFieldNames = new String[]{};
        this.hasPreviousTransforms = false;
        try {
            TransformMeta[] prevTransforms = this.pipelineMeta.getPrevTransforms(this.transformMeta);
            if (prevTransforms.length > 0) {
                IRowMeta prevTransformFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
                inputFieldNames = prevTransformFields.getFieldNames();
                this.hasPreviousTransforms = true;
            }
        }
        catch (HopException e2) {
            this.log.logError("Couldn't get input fields for transform " + this.transformMeta.getName() + " : " + e2.getMessage());
        }
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlTestNameInputField = new Label((Composite)this.shell, 131072);
        wlTestNameInputField.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.TestNameInputField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTestNameInputField);
        FormData fdlTestNameInputField = new FormData();
        fdlTestNameInputField.left = new FormAttachment(0, 0);
        fdlTestNameInputField.right = new FormAttachment(middle, -margin);
        fdlTestNameInputField.top = new FormAttachment((Control)lastControl, margin);
        wlTestNameInputField.setLayoutData((Object)fdlTestNameInputField);
        this.wTestNameInputField = new Combo((Composite)this.shell, 18436);
        this.wTestNameInputField.setItems(inputFieldNames);
        PropsUi.setLook((Widget)this.wTestNameInputField);
        FormData fdTestNameInputField = new FormData();
        fdTestNameInputField.left = new FormAttachment(middle, 0);
        fdTestNameInputField.top = new FormAttachment((Control)lastControl, margin);
        fdTestNameInputField.right = new FormAttachment(100, 0);
        this.wTestNameInputField.setLayoutData((Object)fdTestNameInputField);
        this.wTestNameInputField.addModifyListener(e -> this.enableFields());
        lastControl = this.wTestNameInputField;
        Label wlTypeToExecute = new Label((Composite)this.shell, 131072);
        wlTypeToExecute.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.TypeToExecute.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTypeToExecute);
        FormData fdlTypeToExecute = new FormData();
        fdlTypeToExecute.left = new FormAttachment(0, 0);
        fdlTypeToExecute.right = new FormAttachment(middle, -margin);
        fdlTypeToExecute.top = new FormAttachment((Control)lastControl, margin);
        wlTypeToExecute.setLayoutData((Object)fdlTypeToExecute);
        this.wTypeToExecute = new Combo((Composite)this.shell, 18436);
        this.wTypeToExecute.setItems(DataSetConst.getTestTypeDescriptions());
        PropsUi.setLook((Widget)this.wTypeToExecute);
        FormData fdTypeToExecute = new FormData();
        fdTypeToExecute.left = new FormAttachment(middle, 0);
        fdTypeToExecute.top = new FormAttachment((Control)lastControl, margin);
        fdTypeToExecute.right = new FormAttachment(100, 0);
        this.wTypeToExecute.setLayoutData((Object)fdTypeToExecute);
        lastControl = this.wTypeToExecute;
        Label wlPipelineNameField = new Label((Composite)this.shell, 131072);
        wlPipelineNameField.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.PipelineNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPipelineNameField);
        FormData fdlPipelineNameField = new FormData();
        fdlPipelineNameField.left = new FormAttachment(0, 0);
        fdlPipelineNameField.right = new FormAttachment(middle, -margin);
        fdlPipelineNameField.top = new FormAttachment((Control)lastControl, margin);
        wlPipelineNameField.setLayoutData((Object)fdlPipelineNameField);
        this.wPipelineNameField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPipelineNameField);
        FormData fdPipelineNameField = new FormData();
        fdPipelineNameField.left = new FormAttachment(middle, 0);
        fdPipelineNameField.top = new FormAttachment((Control)lastControl, margin);
        fdPipelineNameField.right = new FormAttachment(100, 0);
        this.wPipelineNameField.setLayoutData((Object)fdPipelineNameField);
        lastControl = this.wPipelineNameField;
        Label wlUnitTestNameField = new Label((Composite)this.shell, 131072);
        wlUnitTestNameField.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.UnitTestNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUnitTestNameField);
        FormData fdlUnitTestNameField = new FormData();
        fdlUnitTestNameField.left = new FormAttachment(0, 0);
        fdlUnitTestNameField.right = new FormAttachment(middle, -margin);
        fdlUnitTestNameField.top = new FormAttachment((Control)lastControl, margin);
        wlUnitTestNameField.setLayoutData((Object)fdlUnitTestNameField);
        this.wUnitTestNameField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wUnitTestNameField);
        FormData fdUnitTestNameField = new FormData();
        fdUnitTestNameField.left = new FormAttachment(middle, 0);
        fdUnitTestNameField.top = new FormAttachment((Control)lastControl, margin);
        fdUnitTestNameField.right = new FormAttachment(100, 0);
        this.wUnitTestNameField.setLayoutData((Object)fdUnitTestNameField);
        lastControl = this.wUnitTestNameField;
        Label wlDataSetNameField = new Label((Composite)this.shell, 131072);
        wlDataSetNameField.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.DataSetNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataSetNameField);
        FormData fdlDataSetNameField = new FormData();
        fdlDataSetNameField.left = new FormAttachment(0, 0);
        fdlDataSetNameField.right = new FormAttachment(middle, -margin);
        fdlDataSetNameField.top = new FormAttachment((Control)lastControl, margin);
        wlDataSetNameField.setLayoutData((Object)fdlDataSetNameField);
        this.wDataSetNameField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDataSetNameField);
        FormData fdDataSetNameField = new FormData();
        fdDataSetNameField.left = new FormAttachment(middle, 0);
        fdDataSetNameField.top = new FormAttachment((Control)lastControl, margin);
        fdDataSetNameField.right = new FormAttachment(100, 0);
        this.wDataSetNameField.setLayoutData((Object)fdDataSetNameField);
        lastControl = this.wDataSetNameField;
        Label wlTransformNameField = new Label((Composite)this.shell, 131072);
        wlTransformNameField.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.TransformNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformNameField);
        FormData fdlTransformNameField = new FormData();
        fdlTransformNameField.left = new FormAttachment(0, 0);
        fdlTransformNameField.right = new FormAttachment(middle, -margin);
        fdlTransformNameField.top = new FormAttachment((Control)lastControl, margin);
        wlTransformNameField.setLayoutData((Object)fdlTransformNameField);
        this.wTransformNameField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformNameField);
        FormData fdTransformNameField = new FormData();
        fdTransformNameField.left = new FormAttachment(middle, 0);
        fdTransformNameField.top = new FormAttachment((Control)lastControl, margin);
        fdTransformNameField.right = new FormAttachment(100, 0);
        this.wTransformNameField.setLayoutData((Object)fdTransformNameField);
        lastControl = this.wTransformNameField;
        Label wlErrorField = new Label((Composite)this.shell, 131072);
        wlErrorField.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.ErrorField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlErrorField);
        FormData fdlErrorField = new FormData();
        fdlErrorField.left = new FormAttachment(0, 0);
        fdlErrorField.right = new FormAttachment(middle, -margin);
        fdlErrorField.top = new FormAttachment((Control)lastControl, margin);
        wlErrorField.setLayoutData((Object)fdlErrorField);
        this.wErrorField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wErrorField);
        FormData fdErrorField = new FormData();
        fdErrorField.left = new FormAttachment(middle, 0);
        fdErrorField.top = new FormAttachment((Control)lastControl, margin);
        fdErrorField.right = new FormAttachment(100, 0);
        this.wErrorField.setLayoutData((Object)fdErrorField);
        lastControl = this.wErrorField;
        Label wlCommentField = new Label((Composite)this.shell, 131072);
        wlCommentField.setText(BaseMessages.getString(PKG, (String)"ExecuteTestsDialog.CommentField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCommentField);
        FormData fdlCommentField = new FormData();
        fdlCommentField.left = new FormAttachment(0, 0);
        fdlCommentField.right = new FormAttachment(middle, -margin);
        fdlCommentField.top = new FormAttachment((Control)lastControl, margin);
        wlCommentField.setLayoutData((Object)fdlCommentField);
        this.wCommentField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCommentField);
        FormData fdCommentField = new FormData();
        fdCommentField.left = new FormAttachment(middle, 0);
        fdCommentField.top = new FormAttachment((Control)lastControl, margin);
        fdCommentField.right = new FormAttachment(100, 0);
        this.wCommentField.setLayoutData((Object)fdCommentField);
        lastControl = this.wCommentField;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void enableFields() {
        boolean previous = this.hasPreviousTransforms && StringUtils.isNotEmpty((String)this.wTestNameInputField.getText());
        this.wTestNameInputField.setEnabled(this.hasPreviousTransforms);
        this.wTypeToExecute.setEnabled(!previous);
    }

    private void getData() {
        this.wTestNameInputField.setText(Const.NVL((String)this.input.getTestNameInputField(), (String)""));
        this.wTypeToExecute.setText(DataSetConst.getTestTypeDescription(this.input.getTypeToExecute()));
        this.wPipelineNameField.setText(Const.NVL((String)this.input.getPipelineNameField(), (String)""));
        this.wUnitTestNameField.setText(Const.NVL((String)this.input.getUnitTestNameField(), (String)""));
        this.wDataSetNameField.setText(Const.NVL((String)this.input.getDataSetNameField(), (String)""));
        this.wTransformNameField.setText(Const.NVL((String)this.input.getTransformNameField(), (String)""));
        this.wErrorField.setText(Const.NVL((String)this.input.getErrorField(), (String)""));
        this.wCommentField.setText(Const.NVL((String)this.input.getCommentField(), (String)""));
        this.enableFields();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setChanged();
        this.input.setTestNameInputField(this.wTestNameInputField.getText());
        this.input.setTypeToExecute(DataSetConst.getTestTypeForDescription(this.wTypeToExecute.getText()));
        this.input.setPipelineNameField(this.wPipelineNameField.getText());
        this.input.setUnitTestNameField(this.wUnitTestNameField.getText());
        this.input.setDataSetNameField(this.wDataSetNameField.getText());
        this.input.setTransformNameField(this.wTransformNameField.getText());
        this.input.setErrorField(this.wErrorField.getText());
        this.input.setCommentField(this.wCommentField.getText());
        this.dispose();
    }
}

