/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.PaperDownloadFormat;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class PaperDocDownloadDetails {
    @Nonnull
    protected final String eventUuid;
    @Nonnull
    protected final PaperDownloadFormat exportFileFormat;

    public PaperDocDownloadDetails(@Nonnull String eventUuid, @Nonnull PaperDownloadFormat exportFileFormat) {
        if (eventUuid == null) {
            throw new IllegalArgumentException("Required value for 'eventUuid' is null");
        }
        this.eventUuid = eventUuid;
        if (exportFileFormat == null) {
            throw new IllegalArgumentException("Required value for 'exportFileFormat' is null");
        }
        this.exportFileFormat = exportFileFormat;
    }

    @Nonnull
    public String getEventUuid() {
        return this.eventUuid;
    }

    @Nonnull
    public PaperDownloadFormat getExportFileFormat() {
        return this.exportFileFormat;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.eventUuid, this.exportFileFormat});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperDocDownloadDetails other = (PaperDocDownloadDetails)obj;
            return !(this.eventUuid != other.eventUuid && !this.eventUuid.equals(other.eventUuid) || this.exportFileFormat != other.exportFileFormat && !this.exportFileFormat.equals((Object)other.exportFileFormat));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperDocDownloadDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDocDownloadDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("event_uuid");
            StoneSerializers.string().serialize(value.eventUuid, g);
            g.writeFieldName("export_file_format");
            PaperDownloadFormat.Serializer.INSTANCE.serialize(value.exportFileFormat, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperDocDownloadDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            PaperDownloadFormat f_exportFileFormat;
            String f_eventUuid;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_eventUuid = null;
                f_exportFileFormat = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("event_uuid".equals(field)) {
                        f_eventUuid = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("export_file_format".equals(field)) {
                        f_exportFileFormat = PaperDownloadFormat.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_eventUuid == null) {
                    throw new JsonParseException(p, "Required field \"event_uuid\" missing.");
                }
                if (f_exportFileFormat == null) {
                    throw new JsonParseException(p, "Required field \"export_file_format\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperDocDownloadDetails value = new PaperDocDownloadDetails(f_eventUuid, f_exportFileFormat);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

