/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface DefaultCoder {
    @CheckForNull
    public @UnknownKeyFor @Nullable @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder> value();

    public static class DefaultCoderProviderRegistrar
    implements CoderProviderRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CoderProvider> getCoderProviders() {
            return ImmutableList.of((Object)new DefaultCoderProvider());
        }

        public static class DefaultCoderProvider
        extends CoderProvider {
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DefaultCoderProvider.class);

            @Override
            public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                CoderProvider coderProvider;
                Method coderProviderMethod;
                Class<T> clazz = typeDescriptor.getRawType();
                DefaultCoder defaultAnnotation = clazz.getAnnotation(DefaultCoder.class);
                if (defaultAnnotation == null && clazz.getName().contains("AutoValue_")) {
                    clazz = clazz.getSuperclass();
                    defaultAnnotation = clazz.getAnnotation(DefaultCoder.class);
                }
                if (defaultAnnotation == null) {
                    throw new CannotProvideCoderException(String.format("Class %s does not have a @DefaultCoder annotation.", clazz.getName()));
                }
                Class<? extends Coder> defaultAnnotationValue = defaultAnnotation.value();
                if (defaultAnnotationValue == null) {
                    throw new CannotProvideCoderException(String.format("Class %s has a @DefaultCoder annotation with a null value.", clazz.getName()));
                }
                LOG.debug("DefaultCoder annotation found for {} with value {}", clazz, defaultAnnotationValue);
                try {
                    coderProviderMethod = defaultAnnotationValue.getMethod("getCoderProvider", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new CannotProvideCoderException(String.format("Unable to find 'public static CoderProvider getCoderProvider()' on %s", defaultAnnotationValue), e);
                }
                try {
                    coderProvider = Preconditions.checkStateNotNull((CoderProvider)coderProviderMethod.invoke(clazz, new Object[0]));
                }
                catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                    throw new CannotProvideCoderException(String.format("Unable to invoke 'public static CoderProvider getCoderProvider()' on %s", defaultAnnotationValue), e);
                }
                return coderProvider.coderFor(typeDescriptor, componentCoders);
            }
        }
    }
}

