/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogLayout;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.IHopLoggingEventListener;
import org.apache.hop.core.logging.LogMessage;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.vfs.HopVfs;

public class FileLoggingEventListener
implements IHopLoggingEventListener {
    private String filename;
    private FileObject file;
    private OutputStream outputStream;
    private HopLogLayout layout;
    private HopException exception;
    private String logChannelId;

    public FileObject getFile() {
        return this.file;
    }

    public FileLoggingEventListener(String filename, boolean append) throws HopException {
        this(null, filename, append);
    }

    public FileLoggingEventListener(String logChannelId, String filename, boolean append) throws HopException {
        this.logChannelId = logChannelId;
        this.filename = filename;
        this.layout = new HopLogLayout(true);
        this.exception = null;
        this.file = HopVfs.getFileObject(filename);
        this.outputStream = null;
        try {
            this.outputStream = HopVfs.getOutputStream(this.file, append);
        }
        catch (Exception e) {
            throw new HopException("Unable to create a logging event listener to write to file '" + filename + "'", e);
        }
    }

    @Override
    public void eventAdded(HopLoggingEvent event) {
        try {
            Object messageObject = event.getMessage();
            if (messageObject instanceof LogMessage) {
                LogMessage message = (LogMessage)messageObject;
                boolean logToFile = false;
                if (this.logChannelId == null) {
                    logToFile = true;
                } else {
                    List<String> logChannelChildren = LoggingRegistry.getInstance().getLogChannelChildren(this.logChannelId);
                    boolean bl = logToFile = Const.indexOfString(message.getLogChannelId(), logChannelChildren) >= 0;
                }
                if (logToFile) {
                    String logText = this.layout.format(event);
                    this.outputStream.write(logText.getBytes());
                    this.outputStream.write(Const.CR.getBytes());
                    this.outputStream.flush();
                }
            }
        }
        catch (Exception e) {
            this.exception = new HopException("Unable to write to logging event to file '" + this.filename + "'", e);
        }
    }

    public void close() throws HopException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to close output of file '" + this.filename + "'", e);
        }
    }

    public HopException getException() {
        return this.exception;
    }

    public void setException(HopException exception) {
        this.exception = exception;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

