/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ExperimentalApi;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.s2a.internal.channel.S2AHandshakerServiceChannel;
import io.grpc.s2a.internal.handshaker.S2AIdentity;
import io.grpc.s2a.internal.handshaker.S2AProtocolNegotiatorFactory;
import io.grpc.s2a.internal.handshaker.S2AStub;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11533")
public final class S2AChannelCredentials {
    public static Builder newBuilder(String s2aAddress, ChannelCredentials s2aChannelCredentials) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)s2aAddress) ? 1 : 0) != 0, (Object)"S2A address must not be null or empty.");
        Preconditions.checkNotNull((Object)s2aChannelCredentials, (Object)"S2A channel credentials must not be null");
        return new Builder(s2aAddress, s2aChannelCredentials);
    }

    private S2AChannelCredentials() {
    }

    @NotThreadSafe
    public static final class Builder {
        private final String s2aAddress;
        private final ChannelCredentials s2aChannelCredentials;
        private @Nullable S2AIdentity localIdentity = null;
        private @Nullable S2AStub stub = null;

        Builder(String s2aAddress, ChannelCredentials s2aChannelCredentials) {
            this.s2aAddress = s2aAddress;
            this.s2aChannelCredentials = s2aChannelCredentials;
        }

        @CanIgnoreReturnValue
        public Builder setLocalSpiffeId(String localSpiffeId) {
            Preconditions.checkNotNull((Object)localSpiffeId);
            Preconditions.checkArgument((this.localIdentity == null ? 1 : 0) != 0, (Object)"localIdentity is already set.");
            this.localIdentity = S2AIdentity.fromSpiffeId(localSpiffeId);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLocalHostname(String localHostname) {
            Preconditions.checkNotNull((Object)localHostname);
            Preconditions.checkArgument((this.localIdentity == null ? 1 : 0) != 0, (Object)"localIdentity is already set.");
            this.localIdentity = S2AIdentity.fromHostname(localHostname);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLocalUid(String localUid) {
            Preconditions.checkNotNull((Object)localUid);
            Preconditions.checkArgument((this.localIdentity == null ? 1 : 0) != 0, (Object)"localIdentity is already set.");
            this.localIdentity = S2AIdentity.fromUid(localUid);
            return this;
        }

        public Builder setStub(S2AStub stub) {
            Preconditions.checkNotNull((Object)stub);
            this.stub = stub;
            return this;
        }

        public ChannelCredentials build() {
            return InternalNettyChannelCredentials.create((InternalProtocolNegotiator.ClientFactory)this.buildProtocolNegotiatorFactory());
        }

        InternalProtocolNegotiator.ClientFactory buildProtocolNegotiatorFactory() {
            SharedResourcePool s2aChannelPool = SharedResourcePool.forResource(S2AHandshakerServiceChannel.getChannelResource(this.s2aAddress, this.s2aChannelCredentials));
            Preconditions.checkNotNull((Object)s2aChannelPool, (Object)"s2aChannelPool");
            return S2AProtocolNegotiatorFactory.createClientFactory(this.localIdentity, (ObjectPool<Channel>)s2aChannelPool, this.stub);
        }
    }
}

