/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.bind;

import java.util.Arrays;
import java.util.HashSet;

public class NameMapper {
    public static final HashSet<String> keywords = NameMapper.getKeywords();

    private static HashSet<String> getKeywords() {
        String[] keyWordArray = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
        HashSet<String> keywords = new HashSet<String>();
        keywords.addAll(Arrays.asList(keyWordArray));
        return keywords;
    }

    public static String getPackageName(String targetNamespace, String packagePrefix) {
        String pkg;
        StringBuilder packageName;
        if (targetNamespace.startsWith("urn:")) {
            packageName = new StringBuilder(targetNamespace.substring(4));
            packageName = NameMapper.reverse(packageName);
        } else if (targetNamespace.startsWith("http://") || targetNamespace.startsWith("https://")) {
            packageName = new StringBuilder(24).append("com.sforce.soap.");
            int slashpos = targetNamespace.lastIndexOf(47);
            String nsSub = targetNamespace.substring(slashpos + 1);
            if (nsSub == null || "".equals(nsSub)) {
                String tns = targetNamespace.substring(0, slashpos);
                nsSub = tns.substring(tns.lastIndexOf(47) + 1);
            }
            packageName.append(nsSub);
        } else {
            packageName = new StringBuilder(targetNamespace);
        }
        if (packagePrefix != null) {
            packageName.append(".").append(packagePrefix);
        }
        if ((pkg = packageName.toString().replace("/", ".")).endsWith(".")) {
            pkg = pkg.substring(0, pkg.length() - 1);
        }
        return pkg;
    }

    public static String getFieldName(String name) {
        if (keywords.contains(name)) {
            name = "_" + name;
        }
        return name;
    }

    private static StringBuilder reverse(CharSequence packageName) {
        String[] names = packageName.toString().split("\\.");
        StringBuilder sb = new StringBuilder();
        int i = names.length - 1;
        while (i > 0) {
            sb.append(names[i]);
            sb.append(".");
            --i;
        }
        sb.append(names[0]);
        return sb;
    }

    public static String getMethodName(String name) {
        return NameMapper.upperCaseFirstLetterName(name);
    }

    public static String getClassName(String name) {
        return NameMapper.upperCaseFirstLetterName(name);
    }

    private static String upperCaseFirstLetterName(String name) {
        char ch = name.charAt(0);
        String className = Character.isUpperCase(ch) ? name : String.valueOf(Character.toUpperCase(ch)) + name.substring(1, name.length());
        return className;
    }
}

