/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableexists;

import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableexists.TableExistsData;
import org.apache.hop.pipeline.transforms.tableexists.TableExistsMeta;

public class TableExists
extends BaseTransform<TableExistsMeta, TableExistsData> {
    private static final Class<?> PKG = TableExistsMeta.class;

    public TableExists(TransformMeta transformMeta, TableExistsMeta meta, TableExistsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block9: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean tablexists = false;
            try {
                if (this.first) {
                    this.first = false;
                    ((TableExistsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                    ((TableExistsMeta)this.meta).getFields(((TableExistsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    if (Utils.isEmpty((CharSequence)((TableExistsMeta)this.meta).getTableNameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.TablenameFieldMissing", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"TableExists.Error.TablenameFieldMissing", (String[])new String[0]));
                    }
                    if (((TableExistsData)this.data).indexOfTablename < 0) {
                        ((TableExistsData)this.data).indexOfTablename = this.getInputRowMeta().indexOfValue(((TableExistsMeta)this.meta).getTableNameField());
                        if (((TableExistsData)this.data).indexOfTablename < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"TableExists.Exception.CouldnotFindField", (String[])new String[0]) + "[" + ((TableExistsMeta)this.meta).getTableNameField() + "]");
                            throw new HopException(BaseMessages.getString(PKG, (String)"TableExists.Exception.CouldnotFindField", (String[])new String[]{((TableExistsMeta)this.meta).getTableNameField()}));
                        }
                    }
                }
                String tableName = this.getInputRowMeta().getString(r, ((TableExistsData)this.data).indexOfTablename);
                tablexists = ((TableExistsData)this.data).db.checkTableExists(((TableExistsData)this.data).realSchemaname, tableName);
                Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)tablexists);
                this.putRow(((TableExistsData)this.data).outputRowMeta, outputRowData);
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"TableExists.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)("TableExists.ErrorInTransformRunning : " + e.getMessage()), (String[])new String[0]));
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableExists.Log.ErrorInTransform", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block9;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((TableExistsMeta)this.meta).getResultFieldName(), "TableExistsO01");
            }
        }
        return true;
    }

    public boolean init() {
        block7: {
            if (super.init()) {
                if (Utils.isEmpty((CharSequence)((TableExistsMeta)this.meta).getResultFieldName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.ResultFieldMissing", (String[])new String[0]));
                    return false;
                }
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((TableExistsMeta)this.meta).getConnection(), this.variables);
                if (databaseMeta == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"TableExists.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((TableExistsData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
                if (!Utils.isEmpty((CharSequence)((TableExistsMeta)this.meta).getSchemaName())) {
                    ((TableExistsData)this.data).realSchemaname = this.resolve(((TableExistsMeta)this.meta).getSchemaName());
                }
                try {
                    ((TableExistsData)this.data).db.connect();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    return true;
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"TableExists.Log.DBException", (String[])new String[0]) + e.getMessage());
                    if (((TableExistsData)this.data).db == null) break block7;
                    ((TableExistsData)this.data).db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (((TableExistsData)this.data).db != null) {
            ((TableExistsData)this.data).db.disconnect();
        }
        super.dispose();
    }
}

