/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.VertexStatistics;
import org.apache.tez.runtime.api.events.CustomProcessorEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public interface VertexManagerPluginContext {
    public Map<String, EdgeProperty> getInputVertexEdgeProperties();

    public Map<String, EdgeProperty> getOutputVertexEdgeProperties();

    public VertexStatistics getVertexStatistics(String var1);

    public String getVertexName();

    public UserPayload getUserPayload();

    public int getVertexNumTasks(String var1);

    public Resource getVertexTaskResource();

    public Resource getTotalAvailableResource();

    public int getNumClusterNodes();

    @Deprecated
    public void setVertexParallelism(int var1, @Nullable VertexLocationHint var2, @Nullable Map<String, EdgeManagerPluginDescriptor> var3, @Nullable Map<String, InputSpecUpdate> var4);

    public void reconfigureVertex(int var1, @Nullable VertexLocationHint var2, @Nullable Map<String, EdgeProperty> var3, @Nullable Map<String, InputSpecUpdate> var4);

    public void reconfigureVertex(int var1, @Nullable VertexLocationHint var2, @Nullable Map<String, EdgeProperty> var3);

    public void reconfigureVertex(@Nullable Map<String, InputSpecUpdate> var1, @Nullable VertexLocationHint var2, int var3);

    public void addRootInputEvents(String var1, Collection<InputDataInformationEvent> var2);

    public void sendEventToProcessor(Collection<CustomProcessorEvent> var1, int var2);

    @Deprecated
    public void scheduleVertexTasks(List<TaskWithLocationHint> var1);

    public void scheduleTasks(List<ScheduleTaskRequest> var1);

    @Nullable
    public Set<String> getVertexInputNames();

    public void setVertexLocationHint(VertexLocationHint var1);

    public int getDAGAttemptNumber();

    public void registerForVertexStateUpdates(String var1, @Nullable Set<VertexState> var2);

    public void vertexReconfigurationPlanned();

    public void doneReconfiguringVertex();

    public Map<String, List<String>> getInputVertexGroups();

    @Deprecated
    public static class TaskWithLocationHint {
        Integer taskIndex;
        TaskLocationHint locationHint;

        public TaskWithLocationHint(Integer taskIndex, @Nullable TaskLocationHint locationHint) {
            this.taskIndex = Objects.requireNonNull(taskIndex);
            this.locationHint = locationHint;
        }

        public Integer getTaskIndex() {
            return this.taskIndex;
        }

        public TaskLocationHint getTaskLocationHint() {
            return this.locationHint;
        }
    }

    public static class ScheduleTaskRequest {
        int taskIndex;
        TaskLocationHint locationHint;

        public static ScheduleTaskRequest create(int taskIndex, @Nullable TaskLocationHint locationHint) {
            return new ScheduleTaskRequest(taskIndex, locationHint);
        }

        private ScheduleTaskRequest(int taskIndex, @Nullable TaskLocationHint locationHint) {
            Preconditions.checkState(taskIndex >= 0);
            this.taskIndex = taskIndex;
            this.locationHint = locationHint;
        }

        public int getTaskIndex() {
            return this.taskIndex;
        }

        public TaskLocationHint getTaskLocationHint() {
            return this.locationHint;
        }
    }
}

