/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.CompareAndCopy;
import org.apache.datasketches.memory.internal.UnsafeUtil;

abstract class NonNativeWritableBufferImpl
extends BaseWritableBufferImpl {
    NonNativeWritableBufferImpl(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
    }

    @Override
    public char getChar() {
        return Character.reverseBytes(this.getNativeOrderedChar());
    }

    @Override
    public char getChar(long offsetBytes) {
        return Character.reverseBytes(this.getNativeOrderedChar(offsetBytes));
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeChars(this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes, dstArray, dstOffsetChars, lengthChars);
    }

    @Override
    public double getDouble() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 8L);
        return Double.longBitsToDouble(Long.reverseBytes(UnsafeUtil.unsafe.getLong(this.getUnsafeObject(), this.getCumulativeOffset(pos))));
    }

    @Override
    public double getDouble(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return Double.longBitsToDouble(Long.reverseBytes(UnsafeUtil.unsafe.getLong(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes))));
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeDoubles(this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes, dstArray, dstOffsetDoubles, lengthDoubles);
    }

    @Override
    public float getFloat() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 4L);
        return Float.intBitsToFloat(Integer.reverseBytes(UnsafeUtil.unsafe.getInt(this.getUnsafeObject(), this.getCumulativeOffset(pos))));
    }

    @Override
    public float getFloat(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return Float.intBitsToFloat(Integer.reverseBytes(UnsafeUtil.unsafe.getInt(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes))));
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeFloats(this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes, dstArray, dstOffsetFloats, lengthFloats);
    }

    @Override
    public int getInt() {
        return Integer.reverseBytes(this.getNativeOrderedInt());
    }

    @Override
    public int getInt(long offsetBytes) {
        return Integer.reverseBytes(this.getNativeOrderedInt(offsetBytes));
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeInts(this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes, dstArray, dstOffsetInts, lengthInts);
    }

    @Override
    public long getLong() {
        return Long.reverseBytes(this.getNativeOrderedLong());
    }

    @Override
    public long getLong(long offsetBytes) {
        return Long.reverseBytes(this.getNativeOrderedLong(offsetBytes));
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeLongs(this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes, dstArray, dstOffsetLongs, lengthLongs);
    }

    @Override
    public short getShort() {
        return Short.reverseBytes(this.getNativeOrderedShort());
    }

    @Override
    public short getShort(long offsetBytes) {
        return Short.reverseBytes(this.getNativeOrderedShort(offsetBytes));
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeShorts(this.getUnsafeObject(), this.getCumulativeOffset(pos), copyBytes, dstArray, dstOffsetShorts, lengthShorts);
    }

    @Override
    public void putChar(char value) {
        this.putNativeOrderedChar(Character.reverseBytes(value));
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.putNativeOrderedChar(offsetBytes, Character.reverseBytes(value));
    }

    @Override
    public void putCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeChars(srcArray, srcOffsetChars, lengthChars, copyBytes, this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    @Override
    public void putDouble(double value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 8L);
        UnsafeUtil.unsafe.putLong(this.getUnsafeObject(), this.getCumulativeOffset(pos), Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putLong(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public void putDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeDoubles(srcArray, srcOffsetDoubles, lengthDoubles, copyBytes, this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    @Override
    public void putFloat(float value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 4L);
        UnsafeUtil.unsafe.putInt(this.getUnsafeObject(), this.getCumulativeOffset(pos), Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putInt(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public void putFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeFloats(srcArray, srcOffsetFloats, lengthFloats, copyBytes, this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    @Override
    public void putInt(int value) {
        this.putNativeOrderedInt(Integer.reverseBytes(value));
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.putNativeOrderedInt(offsetBytes, Integer.reverseBytes(value));
    }

    @Override
    public void putIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeInts(srcArray, srcOffsetInts, lengthInts, copyBytes, this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    @Override
    public void putLong(long value) {
        this.putNativeOrderedLong(Long.reverseBytes(value));
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.putNativeOrderedLong(offsetBytes, Long.reverseBytes(value));
    }

    @Override
    public void putLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeLongs(srcArray, srcOffsetLongs, lengthLongs, copyBytes, this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }

    @Override
    public void putShort(short value) {
        this.putNativeOrderedShort(Short.reverseBytes(value));
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.putNativeOrderedShort(offsetBytes, Short.reverseBytes(value));
    }

    @Override
    public void putShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeShorts(srcArray, srcOffsetShorts, lengthShorts, copyBytes, this.getUnsafeObject(), this.getCumulativeOffset(pos));
    }
}

