/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.junit.Assert;
import org.junit.Test;

public class TestErasureCodingPolicyInfo {
    @Test
    public void testPolicyAndStateCantBeNull() {
        try {
            new ErasureCodingPolicyInfo(null);
            Assert.fail((String)"Null policy should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicyInfo(SystemErasureCodingPolicies.getByID((byte)1), null);
            Assert.fail((String)"Null policy state should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testStates() {
        ErasureCodingPolicyInfo info = new ErasureCodingPolicyInfo(SystemErasureCodingPolicies.getByID((byte)1));
        info.setState(ErasureCodingPolicyState.ENABLED);
        Assert.assertFalse((boolean)info.isDisabled());
        Assert.assertTrue((boolean)info.isEnabled());
        Assert.assertFalse((boolean)info.isRemoved());
        info.setState(ErasureCodingPolicyState.REMOVED);
        Assert.assertFalse((boolean)info.isDisabled());
        Assert.assertFalse((boolean)info.isEnabled());
        Assert.assertTrue((boolean)info.isRemoved());
        info.setState(ErasureCodingPolicyState.DISABLED);
        Assert.assertTrue((boolean)info.isDisabled());
        Assert.assertFalse((boolean)info.isEnabled());
        Assert.assertFalse((boolean)info.isRemoved());
    }
}

