/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ManagedServletPipeline;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class FilterChainInvocation
implements FilterChain {
    private static final ImmutableSet<String> SERVLET_INTERNAL_METHODS = ImmutableSet.of((Object)(FilterChainInvocation.class.getName() + ".doFilter"));
    private final FilterDefinition[] filterDefinitions;
    private final FilterChain proceedingChain;
    private final ManagedServletPipeline servletPipeline;
    private int index = -1;
    private boolean cleanedStacks = false;

    public FilterChainInvocation(FilterDefinition[] filterDefinitions, ManagedServletPipeline servletPipeline, FilterChain proceedingChain) {
        this.filterDefinitions = filterDefinitions;
        this.servletPipeline = servletPipeline;
        this.proceedingChain = proceedingChain;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        GuiceFilter.Context previous = GuiceFilter.localContext.get();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest originalRequest = previous != null ? previous.getOriginalRequest() : request;
        GuiceFilter.localContext.set(new GuiceFilter.Context(originalRequest, request, response));
        try {
            Filter filter = this.findNextFilter(request);
            if (filter != null) {
                filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
            } else {
                boolean serviced = this.servletPipeline.service(servletRequest, servletResponse);
                if (!serviced) {
                    this.proceedingChain.doFilter(servletRequest, servletResponse);
                }
            }
        }
        catch (Throwable t) {
            if (!this.cleanedStacks) {
                this.cleanedStacks = true;
                this.pruneStacktrace(t);
            }
            Throwables.propagateIfInstanceOf((Throwable)t, ServletException.class);
            Throwables.propagateIfInstanceOf((Throwable)t, IOException.class);
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            GuiceFilter.localContext.set(previous);
        }
    }

    private Filter findNextFilter(HttpServletRequest request) {
        while (++this.index < this.filterDefinitions.length) {
            Filter filter = this.filterDefinitions[this.index].getFilterIfMatching(request);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    private void pruneStacktrace(Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            StackTraceElement[] stackTrace = t.getStackTrace();
            ArrayList pruned = Lists.newArrayList();
            for (StackTraceElement element : stackTrace) {
                String name = element.getClassName() + "." + element.getMethodName();
                if (SERVLET_INTERNAL_METHODS.contains((Object)name)) continue;
                pruned.add(element);
            }
            t.setStackTrace(pruned.toArray(new StackTraceElement[pruned.size()]));
        }
    }
}

