/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import org.apache.hadoop.fs.impl.prefetch.BufferData;
import org.apache.hadoop.fs.impl.prefetch.FilePosition;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestFilePosition
extends AbstractHadoopTestBase {
    @Test
    public void testArgChecks() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        BufferData data = new BufferData(0, buffer);
        new FilePosition(0L, 0);
        new FilePosition(0L, 5);
        new FilePosition(10L, 5);
        new FilePosition(5L, 10);
        new FilePosition(10L, 5).setData(data, 3L, 4L);
        new FilePosition(10L, 10).setData(data, 3L, 13L);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'fileSize' must not be negative", () -> new FilePosition(-1L, 2));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockSize' must be a positive integer", () -> new FilePosition(1L, 0));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockSize' must be a positive integer", () -> new FilePosition(1L, -1));
        FilePosition pos = new FilePosition(10L, 3);
        LambdaTestUtils.intercept(IllegalStateException.class, "'buffer' must not be null", () -> pos.buffer());
        LambdaTestUtils.intercept(IllegalStateException.class, "'buffer' must not be null", () -> pos.absolute());
        LambdaTestUtils.intercept(IllegalStateException.class, "'buffer' must not be null", () -> pos.isWithinCurrentBuffer(2L));
        LambdaTestUtils.intercept(IllegalStateException.class, "'buffer' must not be null", () -> pos.blockNumber());
        LambdaTestUtils.intercept(IllegalStateException.class, "'buffer' must not be null", () -> pos.isLastBlock());
        LambdaTestUtils.intercept(IllegalStateException.class, "'buffer' must not be null", () -> pos.bufferFullyRead());
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'bufferData' must not be null", () -> pos.setData(null, 4L, 4L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'startOffset' must not be negative", () -> pos.setData(data, -4L, 4L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'readOffset' must not be negative", () -> pos.setData(data, 4L, -4L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'readOffset' must not be negative", () -> pos.setData(data, 4L, -4L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'readOffset' (15) must be within the range [4, 14]", () -> pos.setData(data, 4L, 15L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'readOffset' (3) must be within the range [4, 14]", () -> pos.setData(data, 4L, 3L));
    }

    @Test
    public void testValidity() {
        int bufferSize = 8;
        long fileSize = 100L;
        long bufferStartOffset = 7L;
        long readStartOffset = 9L;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        BufferData data = new BufferData(0, buffer);
        FilePosition pos = new FilePosition(fileSize, bufferSize);
        Assert.assertFalse((boolean)pos.isValid());
        pos.setData(data, bufferStartOffset, readStartOffset);
        Assert.assertTrue((boolean)pos.isValid());
        pos.invalidate();
        Assert.assertFalse((boolean)pos.isValid());
    }

    @Test
    public void testOffsets() {
        int bufferSize = 8;
        long fileSize = 100L;
        long bufferStartOffset = 7L;
        long readStartOffset = 9L;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        BufferData data = new BufferData(0, buffer);
        FilePosition pos = new FilePosition(fileSize, bufferSize);
        pos.setData(data, bufferStartOffset, readStartOffset);
        Assert.assertTrue((boolean)pos.isValid());
        Assert.assertEquals((long)readStartOffset, (long)pos.absolute());
        Assert.assertEquals((long)(readStartOffset - bufferStartOffset), (long)pos.relative());
        Assert.assertTrue((boolean)pos.isWithinCurrentBuffer(8L));
        Assert.assertFalse((boolean)pos.isWithinCurrentBuffer(6L));
        Assert.assertFalse((boolean)pos.isWithinCurrentBuffer(1L));
        int expectedBlockNumber = (int)(bufferStartOffset / (long)bufferSize);
        Assert.assertEquals((long)expectedBlockNumber, (long)pos.blockNumber());
        Assert.assertFalse((boolean)pos.isLastBlock());
        pos.setData(data, fileSize - 3L, fileSize - 2L);
        Assert.assertTrue((boolean)pos.isLastBlock());
    }

    @Test
    public void testBufferStats() {
        int bufferSize = 8;
        long fileSize = 100L;
        long bufferStartOffset = 7L;
        long readStartOffset = 9L;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        BufferData data = new BufferData(0, buffer);
        FilePosition pos = new FilePosition(fileSize, bufferSize);
        pos.setData(data, bufferStartOffset, readStartOffset);
        Assert.assertTrue((boolean)pos.isValid());
        Assert.assertEquals((long)bufferStartOffset, (long)pos.bufferStartOffset());
        Assert.assertEquals((long)0L, (long)pos.numBytesRead());
        Assert.assertEquals((long)0L, (long)pos.numSingleByteReads());
        Assert.assertEquals((long)0L, (long)pos.numBufferReads());
        pos.incrementBytesRead(1);
        pos.incrementBytesRead(1);
        pos.incrementBytesRead(1);
        pos.incrementBytesRead(5);
        pos.incrementBytesRead(51);
        Assert.assertEquals((long)59L, (long)pos.numBytesRead());
        Assert.assertEquals((long)3L, (long)pos.numSingleByteReads());
        Assert.assertEquals((long)2L, (long)pos.numBufferReads());
        Assert.assertFalse((boolean)pos.bufferFullyRead());
        pos.setData(data, bufferStartOffset, bufferStartOffset);
        Assert.assertTrue((boolean)pos.isValid());
        Assert.assertEquals((long)0L, (long)pos.numBytesRead());
        Assert.assertEquals((long)0L, (long)pos.numSingleByteReads());
        Assert.assertEquals((long)0L, (long)pos.numBufferReads());
        for (int i = 0; i < bufferSize; ++i) {
            pos.buffer().get();
            pos.incrementBytesRead(1);
        }
        Assert.assertTrue((boolean)pos.bufferFullyRead());
    }

    @Test
    public void testBounds() {
        int bufferSize = 8;
        long fileSize = bufferSize;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        BufferData data = new BufferData(0, buffer);
        FilePosition pos = new FilePosition(fileSize, bufferSize);
        long eofOffset = fileSize;
        pos.setData(data, 0L, eofOffset);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pos.isWithinCurrentBuffer(eofOffset)).describedAs("EOF offset %d should be within the current buffer", new Object[]{eofOffset})).isTrue();
        ((AbstractLongAssert)Assertions.assertThat((long)pos.absolute()).describedAs("absolute() should return the EOF offset", new Object[0])).isEqualTo(eofOffset);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pos.setAbsolute(eofOffset)).describedAs("setAbsolute() should return true on the EOF offset %d", new Object[]{eofOffset})).isTrue();
        ((AbstractLongAssert)Assertions.assertThat((long)pos.absolute()).describedAs("absolute() should return the EOF offset", new Object[0])).isEqualTo(eofOffset);
    }
}

