/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.Arrays;
import org.ojalgo.random.Uniform;

public final class IndexSelector {
    private int myExcludedLength;
    private int myIncludedLength;
    private int myLastExcluded;
    private int myLastIncluded;
    private final boolean[] mySelector;

    public IndexSelector(int aCount) {
        this.mySelector = new boolean[aCount];
        this.myExcludedLength = aCount;
        this.myIncludedLength = 0;
        this.myLastExcluded = -1;
        this.myLastIncluded = -1;
    }

    public IndexSelector(int aCount, int[] someInitiallyIncludedIndeces) {
        this(aCount);
        this.include(someInitiallyIncludedIndeces);
    }

    private IndexSelector() {
        this(0);
    }

    public int countExcluded() {
        return this.myExcludedLength;
    }

    public int countIncluded() {
        return this.myIncludedLength;
    }

    public void exclude(int anIndexToExclude) {
        if (this.mySelector[anIndexToExclude]) {
            this.mySelector[anIndexToExclude] = false;
            this.myLastExcluded = anIndexToExclude;
            ++this.myExcludedLength;
            --this.myIncludedLength;
        }
    }

    public void exclude(int[] someIndecesToExclude) {
        for (int i = 0; i < someIndecesToExclude.length; ++i) {
            int tmpIndex = someIndecesToExclude[i];
            if (0 > tmpIndex || tmpIndex >= this.mySelector.length) continue;
            this.exclude(tmpIndex);
        }
    }

    public void excludeAll() {
        Arrays.fill(this.mySelector, false);
        this.myExcludedLength = this.mySelector.length;
        this.myIncludedLength = 0;
    }

    public int[] getExcluded() {
        int[] retVal = new int[this.myExcludedLength];
        int j = 0;
        for (int i = 0; i < this.mySelector.length; ++i) {
            if (this.mySelector[i]) continue;
            retVal[j] = i;
            ++j;
        }
        return retVal;
    }

    public int[] getIncluded() {
        int[] retVal = new int[this.myIncludedLength];
        int j = 0;
        for (int i = 0; i < this.mySelector.length; ++i) {
            if (!this.mySelector[i]) continue;
            retVal[j] = i;
            ++j;
        }
        return retVal;
    }

    public int getLastExcluded() {
        return this.myLastExcluded;
    }

    public int getLastIncluded() {
        return this.myLastIncluded;
    }

    public void grow() {
        if (this.myExcludedLength > 0) {
            int tmpInclRef = Uniform.randomInteger(this.myExcludedLength);
            int tmpExclCount = -1;
            for (int i = 0; i < this.mySelector.length && tmpExclCount < tmpInclRef; ++i) {
                if (!this.mySelector[i]) {
                    ++tmpExclCount;
                }
                if (tmpExclCount != tmpInclRef) continue;
                this.include(i);
            }
        }
    }

    public void include(int anIndexToInclude) {
        if (!this.mySelector[anIndexToInclude]) {
            this.mySelector[anIndexToInclude] = true;
            this.myLastIncluded = anIndexToInclude;
            ++this.myIncludedLength;
            --this.myExcludedLength;
        }
    }

    public void include(int[] someIndecesToInclude) {
        for (int i = 0; i < someIndecesToInclude.length; ++i) {
            int tmpIndex = someIndecesToInclude[i];
            if (0 > tmpIndex || tmpIndex >= this.mySelector.length) continue;
            this.include(tmpIndex);
        }
    }

    public void includeAll() {
        Arrays.fill(this.mySelector, true);
        this.myIncludedLength = this.mySelector.length;
        this.myExcludedLength = 0;
    }

    public boolean isLastExcluded() {
        return !this.mySelector[this.myLastExcluded];
    }

    public boolean isLastIncluded() {
        return this.mySelector[this.myLastIncluded];
    }

    public void revertLastExclusion() {
        this.include(this.myLastExcluded);
    }

    public void revertLastInclusion() {
        this.exclude(this.myLastIncluded);
    }

    public void shrink() {
        if (this.myIncludedLength > 0) {
            int tmpExclRef = Uniform.randomInteger(this.myIncludedLength);
            int tmpInclCount = -1;
            for (int i = 0; i < this.mySelector.length && tmpInclCount < tmpExclRef; ++i) {
                if (this.mySelector[i]) {
                    ++tmpInclCount;
                }
                if (tmpInclCount != tmpExclRef) continue;
                this.exclude(i);
            }
        }
    }

    public void shuffle() {
        if (this.myIncludedLength > 0 && this.myExcludedLength > 0) {
            int tmpExclRef = Uniform.randomInteger(this.myIncludedLength);
            int tmpInclCount = -1;
            int tmpInclRef = Uniform.randomInteger(this.myExcludedLength);
            int tmpExclCount = -1;
            for (int i = 0; i < this.mySelector.length && (tmpInclCount < tmpExclRef || tmpExclCount < tmpInclRef); ++i) {
                if (this.mySelector[i]) {
                    ++tmpInclCount;
                } else {
                    ++tmpExclCount;
                }
                if (tmpInclCount == tmpExclRef) {
                    this.exclude(i);
                    continue;
                }
                if (tmpExclCount != tmpInclRef) continue;
                this.include(i);
            }
        }
    }

    public int size() {
        return this.mySelector.length;
    }

    public String toString() {
        return "Last Incl/Excl: " + this.myLastIncluded + "/" + this.myLastExcluded + " => " + Arrays.toString(this.getIncluded()) + " / " + Arrays.toString(this.getExcluded());
    }
}

