/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import org.ojalgo.access.ColumnView;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;

final class HouseholderColumn<N extends Number>
extends ColumnView<N>
implements HouseholderReference<N> {
    private int myFirst = 0;
    private final MatrixStore<N> myStore;
    private transient Householder<N> myWorker = null;

    public HouseholderColumn(MatrixStore<N> store) {
        super(store);
        this.myStore = store;
    }

    @Override
    public long count() {
        return this.myStore.countRows();
    }

    @Override
    public double doubleValue(long index) {
        if (index > (long)this.myFirst) {
            return this.myStore.doubleValue(index, this.column());
        }
        if (index == (long)this.myFirst) {
            return PrimitiveMath.ONE;
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int first() {
        return this.myFirst;
    }

    @Override
    public N get(long index) {
        if (index > (long)this.myFirst) {
            return this.myStore.get(index, this.column());
        }
        if (index == (long)this.myFirst) {
            return this.myStore.physical().scalar().one().getNumber();
        }
        return this.myStore.physical().scalar().zero().getNumber();
    }

    @Override
    public <P extends Householder<N>> P getWorker(PhysicalStore.Factory<N, ?> factory) {
        if (this.myWorker == null) {
            this.myWorker = factory.makeHouseholder((int)this.count());
        }
        return (P)this.myWorker;
    }

    @Override
    public boolean isZero() {
        return this.myStore.isColumnSmall((long)this.myFirst + 1L, this.column(), PrimitiveMath.ONE);
    }

    @Override
    public void point(long row, long col) {
        this.setColumn(col);
        this.myFirst = (int)row;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("{ ");
        int tmpLastIndex = (int)this.count() - 1;
        for (int i = 0; i < tmpLastIndex; ++i) {
            retVal.append(this.get(i));
            retVal.append(", ");
        }
        retVal.append(this.get(tmpLastIndex));
        retVal.append(" }");
        return retVal.toString();
    }
}

