/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.function.Consumer;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;

public interface Mutate1D
extends Structure1D {
    public void add(long var1, double var3);

    public void add(long var1, Number var3);

    public void set(long var1, double var3);

    public void set(long var1, Number var3);

    public static interface Sortable
    extends Structure1D {
        public void sortAscending();

        public void sortDescending();
    }

    public static interface Receiver<N extends Number>
    extends Mutate1D,
    Fillable<N>,
    Consumer<Access1D<?>> {
        @Override
        default public void accept(Access1D<?> supplied) {
            if (!this.isAcceptable(supplied)) {
                throw new ProgrammingError("Not acceptable!");
            }
            supplied.loopAll(i -> this.set(i, (Number)supplied.get(i)));
        }

        default public boolean isAcceptable(Structure1D supplier) {
            return this.count() >= supplier.count();
        }
    }

    public static interface Modifiable<N extends Number>
    extends Structure1D {
        default public void modifyAll(UnaryFunction<N> modifier) {
            this.modifyRange(0L, this.count(), modifier);
        }

        public void modifyOne(long var1, UnaryFunction<N> var3);

        default public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
            Structure1D.loopRange(first, limit, i -> this.modifyOne(i, modifier));
        }
    }

    public static interface Mixable<N extends Number>
    extends Structure1D {
        public double mix(long var1, BinaryFunction<N> var3, double var4);

        public N mix(long var1, BinaryFunction<N> var3, N var4);
    }

    public static interface Fillable<N extends Number>
    extends Structure1D {
        default public void fillAll(N value) {
            this.fillRange(0L, this.count(), value);
        }

        default public void fillAll(NullaryFunction<N> supplier) {
            this.fillRange(0L, this.count(), supplier);
        }

        default public void fillMatching(Access1D<?> values) {
            Structure1D.loopMatching(this, values, i -> this.fillOne(i, values, i));
        }

        public void fillOne(long var1, Access1D<?> var3, long var4);

        public void fillOne(long var1, N var3);

        public void fillOne(long var1, NullaryFunction<N> var3);

        default public void fillRange(long first, long limit, N value) {
            Structure1D.loopRange(first, limit, i -> this.fillOne(i, value));
        }

        default public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
            Structure1D.loopRange(first, limit, i -> this.fillOne(i, supplier));
        }
    }

    public static interface BiModifiable<N extends Number>
    extends Structure1D {
        public void modifyMatching(Access1D<N> var1, BinaryFunction<N> var2);

        public void modifyMatching(BinaryFunction<N> var1, Access1D<N> var2);
    }
}

