/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerExecContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLinuxContainerRuntime.class);
    private static final String TMP_FILE_PREFIX = "yarn.";
    private static final String TMP_FILE_SUFFIX = ".cmd";
    private final PrivilegedOperationExecutor privilegedOperationExecutor;
    private Configuration conf;

    public DefaultLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
    }

    @Override
    public boolean isRuntimeRequested(Map<String, String> env) {
        String type = env.get("YARN_CONTAINER_RUNTIME_TYPE");
        if (type == null) {
            type = this.conf.get("yarn.nodemanager.runtime.linux.type");
        }
        return type == null || type.isEmpty() || type.equals("default");
    }

    @Override
    public void initialize(Configuration conf, Context nmContext) throws ContainerExecutionException {
        this.conf = conf;
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LAUNCH_CONTAINER);
        launchOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.LAUNCH_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPID), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_ID_STR), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR).toString(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH).toUri().getPath());
        Path keystorePath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_KEYSTORE_PATH);
        Path truststorePath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TRUSTSTORE_PATH);
        if (keystorePath != null && truststorePath != null) {
            launchOp.appendArgs("--https", keystorePath.toUri().getPath(), truststorePath.toUri().getPath());
        } else {
            launchOp.appendArgs("--http");
        }
        launchOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString(), StringUtils.join((char)'%', (Iterable)ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS)), StringUtils.join((char)'%', (Iterable)ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS)), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS));
        String tcCommandFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE);
        if (tcCommandFile != null) {
            launchOp.appendArgs(tcCommandFile);
        }
        launchOp.disableFailureLogging();
        List prefixCommands = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LAUNCH_PREFIX_COMMANDS);
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(prefixCommands, launchOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void relaunchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        this.launchContainer(ctx);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        PrivilegedOperation signalOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
        signalOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL).getValue()));
        signalOp.disableFailureLogging();
        try {
            PrivilegedOperationExecutor executor = PrivilegedOperationExecutor.getInstance(this.conf);
            executor.executePrivilegedOperation(null, signalOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Signal container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    @Override
    public String[] getIpAndHost(Container container) {
        return ContainerExecutor.getLocalIpAndHost(container);
    }

    @Override
    public String getExposedPorts(Container container) {
        return null;
    }

    @Override
    public IOStreamPair execContainer(ContainerExecContext ctx) throws ContainerExecutionException {
        IOStreamPair output;
        try {
            PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.EXEC_CONTAINER);
            String commandFile = this.writeCommandToTempFile(ctx);
            privOp.appendArgs(commandFile);
            privOp.disableFailureLogging();
            output = this.privilegedOperationExecutor.executePrivilegedInteractiveOperation(null, privOp);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Execute container interactive shell failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
        catch (InterruptedException ie) {
            LOG.warn("InterruptedException executing command: ", (Throwable)ie);
            throw new ContainerExecutionException(ie.getMessage());
        }
        return output;
    }

    /*
     * Exception decompiling
     */
    private String writeCommandToTempFile(ContainerExecContext ctx) throws ContainerExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

