/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.Integers;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.Lists;
import com.microsoft.azure.cosmosdb.internal.Longs;
import com.microsoft.azure.cosmosdb.internal.MutableVolatile;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ConflictException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ErrorUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ForbiddenException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.LockedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.MethodNotAllowedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.PartitionKeyRangeGoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.PreconditionFailedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestEntityTooLargeException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestRateTooLargeException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RequestTimeoutException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ResourceOperation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ResponseUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.RetryWithException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ServiceUnavailableException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.UnauthorizedException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.WebExceptionUtility;
import com.microsoft.azure.cosmosdb.rx.internal.BadRequestException;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.HttpClientFactory;
import com.microsoft.azure.cosmosdb.rx.internal.InvalidPartitionException;
import com.microsoft.azure.cosmosdb.rx.internal.NotFoundException;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionIsMigratingException;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionKeyRangeIsSplittingException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.HttpRequestHeaders;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

public class HttpTransportClient
extends TransportClient {
    private final Logger logger = LoggerFactory.getLogger(HttpTransportClient.class);
    private final CompositeHttpClient<ByteBuf, ByteBuf> httpClient;
    private final Map<String, String> defaultHeaders;
    private final Configs configs;

    CompositeHttpClient<ByteBuf, ByteBuf> createHttpClient(int requestTimeout) {
        HttpClientFactory httpClientFactory = new HttpClientFactory(this.configs);
        httpClientFactory.withRequestTimeoutInMillis(requestTimeout * 1000);
        httpClientFactory.withPoolSize(this.configs.getDirectHttpsMaxConnectionLimit());
        return (CompositeHttpClient)httpClientFactory.toHttpClientBuilder().build();
    }

    public HttpTransportClient(Configs configs, int requestTimeout, UserAgentContainer userAgent) {
        this.configs = configs;
        this.httpClient = this.createHttpClient(requestTimeout);
        this.defaultHeaders = new HashMap<String, String>();
        this.defaultHeaders.put("x-ms-version", "2018-09-17");
        this.defaultHeaders.put("Cache-Control", "no-cache");
        if (userAgent == null) {
            userAgent = new UserAgentContainer();
        }
        this.defaultHeaders.put("User-Agent", userAgent.getUserAgent());
        this.defaultHeaders.put("Accept", "application/json");
    }

    @Override
    public void close() {
        this.httpClient.shutdown();
    }

    @Override
    public Single<StoreResponse> invokeStoreAsync(URI physicalAddress, ResourceOperation resourceOperation, RxDocumentServiceRequest request) {
        try {
            UUID activityId = UUID.fromString(request.getActivityId());
            if (resourceOperation.operationType == OperationType.Recreate) {
                HashMap<String, String> errorResponseHeaders = new HashMap<String, String>();
                errorResponseHeaders.put("x-ms-request-validation-failure", "1");
                this.logger.error("Received Recreate request on Http client");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request.", null, errorResponseHeaders, null);
            }
            HttpClientRequest<ByteBuf> httpRequest = this.prepareHttpMessage(activityId, physicalAddress, resourceOperation, request);
            RxClient.ServerInfo serverInfo = new RxClient.ServerInfo(physicalAddress.getHost(), physicalAddress.getPort());
            MutableVolatile sendTimeUtc = new MutableVolatile();
            Single responseMessage = this.httpClient.submit(serverInfo, httpRequest).toSingle();
            responseMessage = responseMessage.doOnSubscribe(() -> {
                sendTimeUtc.v = Instant.now();
                this.beforeRequest(activityId, httpRequest.getUri(), request.getResourceType(), httpRequest.getHeaders());
            });
            responseMessage = responseMessage.onErrorResumeNext(t -> {
                Exception exception = (Exception)com.microsoft.azure.cosmosdb.rx.internal.Utils.as((Object)t, Exception.class);
                if (exception == null) {
                    this.logger.error("critical failure", t);
                    t.printStackTrace();
                    assert (false) : "critical failure";
                    return Single.error((Throwable)t);
                }
                if (WebExceptionUtility.isWebExceptionRetriable((Exception)exception)) {
                    this.logger.debug("Received retriable exception {} sending the request to {}, will re-resolve the address send time UTC: {}", new Object[]{exception, physicalAddress, sendTimeUtc});
                    GoneException goneException = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), exception, null, physicalAddress);
                    return Single.error((Throwable)goneException);
                }
                if (request.isReadOnlyRequest()) {
                    this.logger.trace("Received exception {} on readonly requestsending the request to {}, will reresolve the address send time UTC: {}", new Object[]{exception, physicalAddress, sendTimeUtc});
                    GoneException goneException = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), exception, null, physicalAddress);
                    return Single.error((Throwable)goneException);
                }
                ServiceUnavailableException serviceUnavailableException = new ServiceUnavailableException(String.format("Message: %s", "Service is currently unavailable, please retry after a while. If this problem persists please contact support."), exception, null, physicalAddress.toString());
                serviceUnavailableException.getResponseHeaders().put("x-ms-request-validation-failure", "1");
                serviceUnavailableException.getResponseHeaders().put("x-ms-write-request-trigger-refresh", "1");
                return Single.error((Throwable)((Object)serviceUnavailableException));
            }).doOnSuccess(httpClientResponse -> {
                Instant receivedTimeUtc = Instant.now();
                double durationInMilliSeconds = receivedTimeUtc.toEpochMilli() - ((Instant)sendTimeUtc.v).toEpochMilli();
                this.afterRequest(activityId, httpClientResponse.getStatus().code(), durationInMilliSeconds, httpClientResponse.getHeaders());
            }).doOnError(e -> {
                Instant receivedTimeUtc = Instant.now();
                double durationInMilliSeconds = receivedTimeUtc.toEpochMilli() - ((Instant)sendTimeUtc.v).toEpochMilli();
                this.afterRequest(activityId, 0, durationInMilliSeconds, null);
            });
            return responseMessage.flatMap(rsp -> this.processHttpResponse(request.getResourceAddress(), httpRequest, activityId.toString(), (HttpClientResponse<ByteBuf>)rsp, physicalAddress));
        }
        catch (Exception e2) {
            return Single.error((Throwable)e2);
        }
    }

    private void beforeRequest(UUID activityId, String uri, ResourceType resourceType, HttpRequestHeaders requestHeaders) {
    }

    private void afterRequest(UUID activityId, int statusCode, double durationInMilliSeconds, HttpResponseHeaders responseHeaders) {
    }

    private static void addHeader(HttpRequestHeaders requestHeaders, String headerName, RxDocumentServiceRequest request) {
        String headerValue = (String)request.getHeaders().get(headerName);
        if (!Strings.isNullOrEmpty((String)headerValue)) {
            requestHeaders.add(headerName, (Object)headerValue);
        }
    }

    private static void addHeader(HttpRequestHeaders requestHeaders, String headerName, String headerValue) {
        if (!Strings.isNullOrEmpty((String)headerValue)) {
            requestHeaders.add(headerName, (Object)headerValue);
        }
    }

    private String GetMatch(RxDocumentServiceRequest request, ResourceOperation resourceOperation) {
        switch (resourceOperation.operationType) {
            case Delete: 
            case ExecuteJavaScript: 
            case Replace: 
            case Update: 
            case Upsert: {
                return (String)request.getHeaders().get("If-Match");
            }
            case Read: 
            case ReadFeed: {
                return (String)request.getHeaders().get("If-None-Match");
            }
        }
        return null;
    }

    private HttpClientRequest<ByteBuf> prepareHttpMessage(UUID activityId, URI physicalAddress, ResourceOperation resourceOperation, RxDocumentServiceRequest request) throws Exception {
        HttpClientRequest httpRequestMessage = null;
        switch (resourceOperation.operationType) {
            case Create: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                httpRequestMessage.withContent(request.getContent());
                break;
            }
            case ExecuteJavaScript: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                httpRequestMessage.withContent(request.getContent());
                break;
            }
            case Delete: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.DELETE;
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                break;
            }
            case Read: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.GET;
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                break;
            }
            case ReadFeed: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.GET;
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                break;
            }
            case Replace: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.PUT;
                assert (request.getContent() != null);
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                httpRequestMessage.withContent(request.getContent());
                break;
            }
            case Update: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = new HttpMethod("PATCH");
                assert (request.getContent() != null);
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                httpRequestMessage.withContent(request.getContent());
                break;
            }
            case Query: 
            case SqlQuery: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                httpRequestMessage.withContent(request.getContent());
                HttpTransportClient.addHeader(httpRequestMessage.getHeaders(), "Content-Type", request);
                break;
            }
            case Upsert: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                httpRequestMessage.withContent(request.getContent());
                break;
            }
            case Head: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.HEAD;
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                break;
            }
            case HeadFeed: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.HEAD;
                httpRequestMessage = HttpClientRequest.create((HttpMethod)method, (String)requestUri.toString());
                break;
            }
            default: {
                assert (false) : "Unsupported operation type";
                throw new IllegalStateException();
            }
        }
        Map documentServiceRequestHeaders = request.getHeaders();
        HttpRequestHeaders httpRequestHeaders = httpRequestMessage.getHeaders();
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            HttpTransportClient.addHeader(httpRequestHeaders, entry.getKey(), entry.getValue());
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-version", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "User-Agent", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-max-item-count", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-pre-trigger-include", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-pre-trigger-exclude", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-post-trigger-include", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-post-trigger-exclude", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "authorization", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-indexing-directive", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-migratecollection-directive", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-consistency-level", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-session-token", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "Prefer", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-expiry-seconds", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-enable-scan", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-emit-traces", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cancharge", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-canthrottle", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-enable-low-precision-order-by", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-script-enable-logging", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-is-readonly-script", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-content-serialization-format", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-continuation", request.getContinuation());
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-activity-id", activityId.toString());
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitionkey", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitionkeyrangeid", request);
        String dateHeader = HttpUtils.getDateHeader((Map)documentServiceRequestHeaders);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-date", dateHeader);
        HttpTransportClient.addHeader(httpRequestHeaders, "Match", this.GetMatch(request, resourceOperation));
        HttpTransportClient.addHeader(httpRequestHeaders, "If-Modified-Since", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "A-IM", request);
        if (!request.getIsNameBased()) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-docdb-resource-id", request.getResourceId());
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-docdb-entity-id", request.entityId);
        String fanoutRequestHeader = (String)request.getHeaders().get("x-ms-is-fanout-request");
        HttpTransportClient.addHeader(httpRequestMessage.getHeaders(), "x-ms-is-fanout-request", fanoutRequestHeader);
        if (request.getResourceType() == ResourceType.DocumentCollection) {
            HttpTransportClient.addHeader(httpRequestHeaders, "collection-partition-index", (String)documentServiceRequestHeaders.get("collection-partition-index"));
            HttpTransportClient.addHeader(httpRequestHeaders, "collection-service-index", (String)documentServiceRequestHeaders.get("collection-service-index"));
        }
        if (documentServiceRequestHeaders.get("x-ms-bind-replica") != null) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-bind-replica", (String)documentServiceRequestHeaders.get("x-ms-bind-replica"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-primary-master-key", (String)documentServiceRequestHeaders.get("x-ms-primary-master-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-secondary-master-key", (String)documentServiceRequestHeaders.get("x-ms-secondary-master-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-primary-readonly-key", (String)documentServiceRequestHeaders.get("x-ms-primary-readonly-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-secondary-readonly-key", (String)documentServiceRequestHeaders.get("x-ms-secondary-readonly-key"));
        }
        if (documentServiceRequestHeaders.get("x-ms-can-offer-replace-complete") != null) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-can-offer-replace-complete", (String)documentServiceRequestHeaders.get("x-ms-can-offer-replace-complete"));
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-isquery", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-is-upsert", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-supportspatiallegacycoordinates", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitioncount", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-collection-rid", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-filterby-schema-rid", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-usepolygonssmallerthanahemisphere", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-gateway-signature", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatequotainfo", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatequerymetrics", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-force-query-scan", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-responsecontinuationtokenlimitinkb", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-remote-storage-type", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-share-throughput", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatepartitionstatistics", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatecollectionthroughputinfo", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-remaining-time-in-ms-on-client", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-client-retry-attempt-count", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-target-lsn", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-target-global-committed-lsn", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-federation-for-auth", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-fanout-operation-state", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cosmos-allow-tentative-writes", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-exclude-system-properties", request);
        return httpRequestMessage;
    }

    static URI getResourceFeedUri(ResourceType resourceType, URI physicalAddress, RxDocumentServiceRequest request) throws Exception {
        switch (resourceType) {
            case Attachment: {
                return HttpTransportClient.getAttachmentFeedUri(physicalAddress, request);
            }
            case DocumentCollection: {
                return HttpTransportClient.getCollectionFeedUri(physicalAddress, request);
            }
            case Conflict: {
                return HttpTransportClient.getConflictFeedUri(physicalAddress, request);
            }
            case Database: {
                return HttpTransportClient.getDatabaseFeedUri(physicalAddress);
            }
            case Document: {
                return HttpTransportClient.getDocumentFeedUri(physicalAddress, request);
            }
            case Permission: {
                return HttpTransportClient.getPermissionFeedUri(physicalAddress, request);
            }
            case StoredProcedure: {
                return HttpTransportClient.getStoredProcedureFeedUri(physicalAddress, request);
            }
            case Trigger: {
                return HttpTransportClient.getTriggerFeedUri(physicalAddress, request);
            }
            case User: {
                return HttpTransportClient.getUserFeedUri(physicalAddress, request);
            }
            case UserDefinedFunction: {
                return HttpTransportClient.getUserDefinedFunctionFeedUri(physicalAddress, request);
            }
            case Schema: {
                return HttpTransportClient.getSchemaFeedUri(physicalAddress, request);
            }
            case Offer: {
                return HttpTransportClient.getOfferFeedUri(physicalAddress, request);
            }
        }
        assert (false) : "Unexpected resource type: " + resourceType;
        throw new NotFoundException();
    }

    static URI getResourceEntryUri(ResourceType resourceType, URI physicalAddress, RxDocumentServiceRequest request) throws Exception {
        switch (resourceType) {
            case Attachment: {
                return HttpTransportClient.getAttachmentEntryUri(physicalAddress, request);
            }
            case DocumentCollection: {
                return HttpTransportClient.getCollectionEntryUri(physicalAddress, request);
            }
            case Conflict: {
                return HttpTransportClient.getConflictEntryUri(physicalAddress, request);
            }
            case Database: {
                return HttpTransportClient.getDatabaseEntryUri(physicalAddress, request);
            }
            case Document: {
                return HttpTransportClient.getDocumentEntryUri(physicalAddress, request);
            }
            case Permission: {
                return HttpTransportClient.getPermissionEntryUri(physicalAddress, request);
            }
            case StoredProcedure: {
                return HttpTransportClient.getStoredProcedureEntryUri(physicalAddress, request);
            }
            case Trigger: {
                return HttpTransportClient.getTriggerEntryUri(physicalAddress, request);
            }
            case User: {
                return HttpTransportClient.getUserEntryUri(physicalAddress, request);
            }
            case UserDefinedFunction: {
                return HttpTransportClient.getUserDefinedFunctionEntryUri(physicalAddress, request);
            }
            case Schema: {
                return HttpTransportClient.getSchemaEntryUri(physicalAddress, request);
            }
            case Offer: {
                return HttpTransportClient.getOfferEntryUri(physicalAddress, request);
            }
        }
        assert (false) : "Unexpected resource type: " + resourceType;
        throw new IllegalStateException();
    }

    static URI createURI(URI baseAddress, String resourcePath) {
        return baseAddress.resolve(HttpUtils.urlEncode((String)Utils.trimBeginningAndEndingSlashes((String)resourcePath)));
    }

    static URI getRootFeedUri(URI baseAddress) {
        return baseAddress;
    }

    static URI getDatabaseFeedUri(URI baseAddress) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Database, (String)"", (boolean)true));
    }

    static URI getDatabaseEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Database, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getCollectionFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.DocumentCollection, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getStoredProcedureFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.StoredProcedure, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getTriggerFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Trigger, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getUserDefinedFunctionFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.UserDefinedFunction, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getCollectionEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.DocumentCollection, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getStoredProcedureEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.StoredProcedure, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getTriggerEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Trigger, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getUserDefinedFunctionEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.UserDefinedFunction, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getDocumentFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Document, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getDocumentEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Document, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getConflictFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Conflict, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getConflictEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Conflict, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getAttachmentFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Attachment, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getAttachmentEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Attachment, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getUserFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.User, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getUserEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.User, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getPermissionFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Permission, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getPermissionEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Permission, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getOfferFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Offer, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getSchemaFeedUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Schema, (RxDocumentServiceRequest)request, (boolean)true));
    }

    static URI getSchemaEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Schema, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static URI getOfferEntryUri(URI baseAddress, RxDocumentServiceRequest request) throws Exception {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath((ResourceType)ResourceType.Offer, (RxDocumentServiceRequest)request, (boolean)false));
    }

    static String getHeader(String[] names, String[] values, String name) {
        for (int idx = 0; idx < names.length; ++idx) {
            if (!Strings.areEqual((String)names[idx], (String)name)) continue;
            return values[idx];
        }
        return null;
    }

    private Single<StoreResponse> processHttpResponse(String resourceAddress, HttpClientRequest<ByteBuf> request, String activityId, HttpClientResponse<ByteBuf> response, URI physicalAddress) {
        if (response == null) {
            InternalServerErrorException exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), null, physicalAddress);
            exception.getResponseHeaders().put("x-ms-activity-id", activityId);
            exception.getResponseHeaders().put("x-ms-request-validation-failure", "1");
            return Single.error((Throwable)exception);
        }
        if (response.getStatus().code() < 400 || response.getStatus().code() == 304) {
            return HttpTransportClient.createStoreResponseFromHttpResponse(response);
        }
        return this.createErrorResponseFromHttpResponse(resourceAddress, activityId, request, response);
    }

    private Single<StoreResponse> createErrorResponseFromHttpResponse(String resourceAddress, String activityId, HttpClientRequest<ByteBuf> request, HttpClientResponse<ByteBuf> response) {
        HttpResponseStatus statusCode = response.getStatus();
        Single<String> errorMessageObs = ErrorUtils.getErrorResponseAsync(response);
        return errorMessageObs.flatMap(errorMessage -> {
            Object exception;
            long responseLSN = -1L;
            List lsnValues = response.getHeaders().getAll("lsn");
            if (lsnValues != null) {
                String temp = lsnValues.isEmpty() ? null : (String)lsnValues.get(0);
                responseLSN = Longs.tryParse((String)temp, (long)responseLSN);
            }
            String responsePartitionKeyRangeId = null;
            List partitionKeyRangeIdValues = response.getHeaders().getAll("x-ms-documentdb-partitionkeyrangeid");
            if (partitionKeyRangeIdValues != null) {
                responsePartitionKeyRangeId = (String)Lists.firstOrDefault((List)partitionKeyRangeIdValues, null);
            }
            switch (statusCode.code()) {
                case 401: {
                    exception = new UnauthorizedException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Unable to authenticate the request. The request requires valid user authentication." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 403: {
                    exception = new ForbiddenException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 404: {
                    if (response.getContent() != null && response.getHeaders() != null && response.getHeaders().get("Content-Type") != null && !Strings.isNullOrEmpty((String)response.getHeaders().get("Content-Type")) && Strings.containsIgnoreCase((String)response.getHeaders().get("Content-Type"), (String)"text/html")) {
                        exception = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), request.getUri());
                        exception.getResponseHeaders().put("x-ms-activity-id", activityId);
                        break;
                    }
                    exception = new NotFoundException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Entity with the specified id does not exist in the system." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 400: {
                    exception = new BadRequestException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "One of the input values is invalid." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 405: {
                    exception = new MethodNotAllowedException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "The requested verb is not supported." : errorMessage), null, response.getHeaders(), request.getUri());
                    break;
                }
                case 410: {
                    ErrorUtils.logGoneException(request.getUri(), activityId);
                    Integer nSubStatus = 0;
                    String valueSubStatus = null;
                    valueSubStatus = response.getHeaders().get("x-ms-substatus");
                    if (!Strings.isNullOrEmpty((String)valueSubStatus) && (nSubStatus = Integers.tryParse((String)valueSubStatus)) == null) {
                        exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), response.getHeaders(), request.getUri());
                        break;
                    }
                    if (nSubStatus == 1000) {
                        exception = new InvalidPartitionException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.getHeaders(), request.getUri());
                        break;
                    }
                    if (nSubStatus == 1002) {
                        exception = new PartitionKeyRangeGoneException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.getHeaders(), request.getUri());
                        break;
                    }
                    if (nSubStatus == 1007) {
                        exception = new PartitionKeyRangeIsSplittingException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.getHeaders(), request.getUri());
                        break;
                    }
                    if (nSubStatus == 1008) {
                        exception = new PartitionIsMigratingException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.getHeaders(), request.getUri());
                        break;
                    }
                    exception = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), response.getHeaders(), request.getUri());
                    exception.getResponseHeaders().put("x-ms-activity-id", activityId);
                    break;
                }
                case 409: {
                    exception = new ConflictException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Entity with the specified id already exists in the system." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 412: {
                    exception = new PreconditionFailedException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Operation cannot be performed because one of the specified precondition is not met." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 413: {
                    exception = new RequestEntityTooLargeException(String.format("Message: %s", String.format("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", "x-ms-max-item-count")), response.getHeaders(), request.getUri());
                    break;
                }
                case 423: {
                    exception = new LockedException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "" : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 503: {
                    exception = new ServiceUnavailableException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Service is currently unavailable, please retry after a while. If this problem persists please contact support." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 408: {
                    exception = new RequestTimeoutException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Request timed out." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 449: {
                    exception = new RetryWithException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Retry the request." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                case 429: {
                    exception = new RequestRateTooLargeException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "The request rate is too large. Please retry after sometime." : errorMessage), response.getHeaders(), request.getUri());
                    List values = response.getHeaders().getAll("x-ms-retry-after-ms");
                    if (values == null || values.isEmpty()) {
                        this.logger.warn("RequestRateTooLargeException being thrown without RetryAfter.");
                        break;
                    }
                    exception.getResponseHeaders().put("x-ms-retry-after-ms", values.get(0));
                    break;
                }
                case 500: {
                    exception = new InternalServerErrorException(String.format("Message: %s", Strings.isNullOrEmpty((String)errorMessage) ? "Unknown server error occurred when processing this request." : errorMessage), response.getHeaders(), request.getUri());
                    break;
                }
                default: {
                    this.logger.error("Unrecognized status code {} returned by backend. ActivityId {}", (Object)statusCode, (Object)activityId);
                    ErrorUtils.logException(request.getUri(), activityId);
                    exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), response.getHeaders(), request.getUri());
                }
            }
            BridgeInternal.setLSN((DocumentClientException)((Object)((Object)exception)), (long)responseLSN);
            BridgeInternal.setPartitionKeyRangeId((DocumentClientException)((Object)((Object)exception)), (String)responsePartitionKeyRangeId);
            BridgeInternal.setResourceAddress((DocumentClientException)((Object)((Object)exception)), (String)resourceAddress);
            BridgeInternal.setRequestHeaders((DocumentClientException)((Object)((Object)exception)), (Map)HttpUtils.asMap((HttpRequestHeaders)request.getHeaders()));
            return Single.error((Throwable)exception);
        });
    }

    private static Single<StoreResponse> createStoreResponseFromHttpResponse(HttpClientResponse<ByteBuf> responseMessage) {
        Single<StoreResponse> storeResponse = ResponseUtils.toStoreResponse(responseMessage);
        return storeResponse;
    }
}

