/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@Metrics(context="yarn-native-service")
public class ServiceMetrics
implements MetricsSource {
    @Metric(value={"containers requested"})
    public MutableGaugeInt containersRequested;
    @Metric(value={"containers running"})
    public MutableGaugeInt containersRunning;
    @Metric(value={"containers ready"})
    public MutableGaugeInt containersReady;
    @Metric(value={"containers desired"})
    public MutableGaugeInt containersDesired;
    @Metric(value={"containers succeeded"})
    public MutableGaugeInt containersSucceeded;
    @Metric(value={"containers failed"})
    public MutableGaugeInt containersFailed;
    @Metric(value={"containers preempted"})
    public MutableGaugeInt containersPreempted;
    @Metric(value={"containers surplus"})
    public MutableGaugeInt surplusContainers;
    @Metric(value={"containers failed due to disk failure"})
    public MutableGaugeInt containersDiskFailure;
    protected final MetricsRegistry registry;

    public ServiceMetrics(MetricsInfo metricsInfo) {
        this.registry = new MetricsRegistry(metricsInfo);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public static ServiceMetrics register(String name, String description) {
        ServiceMetrics metrics = new ServiceMetrics(Interns.info((String)name, (String)description));
        DefaultMetricsSystem.instance().register(name, description, (Object)metrics);
        return metrics;
    }

    public void tag(String name, String description, String value) {
        this.registry.tag(name, description, value);
    }

    public String toString() {
        return "ServiceMetrics{containersRequested=" + this.containersRequested.value() + ", containersRunning=" + this.containersRunning.value() + ", containersDesired=" + this.containersDesired.value() + ", containersSucceeded=" + this.containersSucceeded.value() + ", containersFailed=" + this.containersFailed.value() + ", containersPreempted=" + this.containersPreempted.value() + ", surplusContainers=" + this.surplusContainers.value() + '}';
    }
}

