/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.StaticRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterHandlersFairness {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterHandlersFairness.class);
    private StateStoreDFSCluster cluster;

    @After
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void setupCluster(boolean fairnessEnable, boolean ha) throws Exception {
        this.cluster = new StateStoreDFSCluster(ha, 2);
        Configuration routerConf = new RouterConfigBuilder().stateStore().rpc().build();
        if (fairnessEnable) {
            routerConf.setClass("dfs.federation.router.fairness.policy.controller.class", StaticRouterRpcFairnessPolicyController.class, RouterRpcFairnessPolicyController.class);
        }
        routerConf.setInt("dfs.federation.router.handler.count", 3);
        this.cluster.setNumDatanodesPerNameservice(0);
        this.cluster.addRouterOverrides(routerConf);
        this.cluster.startCluster();
        this.cluster.startRouters();
        this.cluster.waitClusterUp();
    }

    @Test
    public void testFairnessControlOff() throws Exception {
        this.setupCluster(false, false);
        this.startLoadTest(false);
    }

    @Test
    public void testFairnessControlOn() throws Exception {
        this.setupCluster(true, false);
        this.startLoadTest(true);
    }

    @Test
    public void testReleasedWhenExceptionOccurs() throws Exception {
        this.setupCluster(true, false);
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        RouterRpcClient rpcClient = routerContext.getRouter().getRpcServer().getRPCClient();
        ActiveNamenodeResolver mockNamenodeResolver = (ActiveNamenodeResolver)Mockito.mock(ActiveNamenodeResolver.class);
        Field field = rpcClient.getClass().getDeclaredField("namenodeResolver");
        field.setAccessible(true);
        field.set(rpcClient, mockNamenodeResolver);
        DFSClient client = routerContext.getClient();
        int availablePermits = rpcClient.getRouterRpcFairnessPolicyController().getAvailablePermits("ns0");
        LambdaTestUtils.intercept(IOException.class, () -> {
            LOG.info("Use getFileInfo test invokeSequential.");
            client.getFileInfo("/test.txt");
        });
        Assert.assertEquals((long)availablePermits, (long)rpcClient.getRouterRpcFairnessPolicyController().getAvailablePermits("ns0"));
        ArrayList<RemoteLocation> locations = new ArrayList<RemoteLocation>();
        locations.add(new RemoteLocation("ns0", "/", "/"));
        RemoteMethod renewLease = new RemoteMethod("renewLease", new Class[]{String.class, List.class}, new Object[]{null, null});
        availablePermits = rpcClient.getRouterRpcFairnessPolicyController().getAvailablePermits("ns0");
        LambdaTestUtils.intercept(IOException.class, () -> {
            LOG.info("Use renewLease test invokeConcurrent.");
            rpcClient.invokeConcurrent(locations, renewLease);
        });
        Assert.assertEquals((long)availablePermits, (long)rpcClient.getRouterRpcFairnessPolicyController().getAvailablePermits("ns0"));
    }

    private void startLoadTest(boolean fairness) throws Exception {
        this.startLoadTest(true, fairness);
        this.startLoadTest(false, fairness);
    }

    private void startLoadTest(boolean isConcurrent, boolean fairness) throws Exception {
        MiniRouterDFSCluster.RouterContext routerContext = this.cluster.getRandomRouter();
        URI address = routerContext.getFileSystemURI();
        HdfsConfiguration conf = new HdfsConfiguration();
        int numOps = 10;
        AtomicInteger overloadException = new AtomicInteger();
        if (fairness) {
            if (isConcurrent) {
                LOG.info("Taking fanout lock first");
                Assert.assertTrue((boolean)routerContext.getRouter().getRpcServer().getRPCClient().getRouterRpcFairnessPolicyController().acquirePermit("concurrent"));
            } else {
                for (String ns : this.cluster.getNameservices()) {
                    LOG.info("Taking lock first for ns: {}", (Object)ns);
                    Assert.assertTrue((boolean)routerContext.getRouter().getRpcServer().getRPCClient().getRouterRpcFairnessPolicyController().acquirePermit(ns));
                }
            }
        }
        int originalRejectedPermits = this.getTotalRejectedPermits(routerContext);
        this.innerCalls(address, 10, isConcurrent, (Configuration)conf, overloadException);
        int latestRejectedPermits = this.getTotalRejectedPermits(routerContext);
        Assert.assertEquals((long)(latestRejectedPermits - originalRejectedPermits), (long)overloadException.get());
        if (fairness) {
            Assert.assertTrue((overloadException.get() > 0 ? 1 : 0) != 0);
            if (isConcurrent) {
                LOG.info("Release fanout lock that was taken before test");
                routerContext.getRouter().getRpcServer().getRPCClient().getRouterRpcFairnessPolicyController().releasePermit("concurrent");
            } else {
                for (String ns : this.cluster.getNameservices()) {
                    routerContext.getRouter().getRpcServer().getRPCClient().getRouterRpcFairnessPolicyController().releasePermit(ns);
                }
            }
        } else {
            Assert.assertEquals((String)"Number of failed RPCs without fairness configured", (long)0L, (long)overloadException.get());
        }
        int originalAcceptedPermits = this.getTotalAcceptedPermits(routerContext);
        overloadException = new AtomicInteger();
        this.innerCalls(address, 10, isConcurrent, (Configuration)conf, overloadException);
        int latestAcceptedPermits = this.getTotalAcceptedPermits(routerContext);
        Assert.assertEquals((long)(latestAcceptedPermits - originalAcceptedPermits), (long)10L);
        Assert.assertEquals((long)overloadException.get(), (long)0L);
    }

    private void invokeSequential(ClientProtocol routerProto) throws IOException {
        routerProto.getFileInfo("/test.txt");
    }

    private void invokeConcurrent(ClientProtocol routerProto, String clientName) throws IOException {
        routerProto.renewLease(clientName, null);
    }

    private int getTotalRejectedPermits(MiniRouterDFSCluster.RouterContext routerContext) {
        int totalRejectedPermits = 0;
        for (String ns : this.cluster.getNameservices()) {
            totalRejectedPermits = (int)((long)totalRejectedPermits + routerContext.getRouterRpcClient().getRejectedPermitForNs(ns));
        }
        totalRejectedPermits = (int)((long)totalRejectedPermits + routerContext.getRouterRpcClient().getRejectedPermitForNs("concurrent"));
        return totalRejectedPermits;
    }

    private int getTotalAcceptedPermits(MiniRouterDFSCluster.RouterContext routerContext) {
        int totalAcceptedPermits = 0;
        for (String ns : this.cluster.getNameservices()) {
            totalAcceptedPermits = (int)((long)totalAcceptedPermits + routerContext.getRouterRpcClient().getAcceptedPermitForNs(ns));
        }
        totalAcceptedPermits = (int)((long)totalAcceptedPermits + routerContext.getRouterRpcClient().getAcceptedPermitForNs("concurrent"));
        return totalAcceptedPermits;
    }

    private void innerCalls(URI address, int numOps, boolean isConcurrent, Configuration conf, AtomicInteger overloadException) throws IOException {
        for (int i = 0; i < numOps; ++i) {
            DFSClient routerClient = null;
            try {
                routerClient = new DFSClient(address, conf);
                String clientName = routerClient.getClientName();
                ClientProtocol routerProto = routerClient.getNamenode();
                if (isConcurrent) {
                    this.invokeConcurrent(routerProto, clientName);
                } else {
                    this.invokeSequential(routerProto);
                }
            }
            catch (RemoteException re) {
                IOException ioe = re.unwrapRemoteException();
                Assert.assertTrue((String)("Wrong exception: " + ioe), (boolean)(ioe instanceof StandbyException));
                GenericTestUtils.assertExceptionContains((String)"is overloaded for NS", (Throwable)ioe);
                overloadException.incrementAndGet();
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                if (routerClient != null) {
                    try {
                        routerClient.close();
                    }
                    catch (IOException e) {
                        LOG.error("Cannot close the client");
                    }
                }
            }
            overloadException.get();
        }
    }
}

