/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system.storedprocedure;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorContext;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorManager;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;
import org.apache.gravitino.trino.connector.system.storedprocedure.GravitinoStoredProcedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterCatalogStoredProcedure
extends GravitinoStoredProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(AlterCatalogStoredProcedure.class);
    private final CatalogConnectorManager catalogConnectorManager;
    private final String metalake;

    public AlterCatalogStoredProcedure(CatalogConnectorManager catalogConnectorManager, String metalake) {
        this.catalogConnectorManager = catalogConnectorManager;
        this.metalake = metalake;
    }

    @Override
    public Procedure createStoredProcedure() throws NoSuchMethodException, IllegalAccessException {
        MethodHandle dropCatalog = MethodHandles.lookup().unreflect(AlterCatalogStoredProcedure.class.getMethod("alterCatalog", String.class, Map.class, List.class)).bindTo(this);
        List<Procedure.Argument> arguments = List.of(new Procedure.Argument("CATALOG", (Type)VarcharType.VARCHAR), new Procedure.Argument("SET_PROPERTIES", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, new TypeOperators())), new Procedure.Argument("REMOVE_PROPERTIES", (Type)new ArrayType((Type)VarcharType.VARCHAR), false, (Object)ArrayBlock.fromElementBlock((int)0, Optional.empty(), (int[])new int[1], (Block)VarcharType.VARCHAR.createBlockBuilder(null, 1).build())));
        return new Procedure("system", "alter_catalog", arguments, dropCatalog);
    }

    public void alterCatalog(String catalogName, Map<String, String> setProperties, List<String> removeProperties) {
        try {
            CatalogConnectorContext catalogConnectorContext = this.catalogConnectorManager.getCatalogConnector(this.catalogConnectorManager.getTrinoCatalogName(this.metalake, catalogName));
            GravitinoCatalog oldCatalog = catalogConnectorContext.getCatalog();
            ArrayList changes = new ArrayList();
            setProperties.forEach((key, value) -> {
                boolean matched = oldCatalog.getProperties().entrySet().stream().anyMatch(oe -> ((String)oe.getKey()).equals(key) && ((String)oe.getValue()).equals(value));
                if (!matched) {
                    changes.add(CatalogChange.setProperty((String)key, (String)value));
                }
            });
            removeProperties.forEach(key -> {
                if (oldCatalog.getProperties().containsKey(key)) {
                    changes.add(CatalogChange.removeProperty((String)key));
                }
            });
            if (changes.isEmpty()) {
                return;
            }
            catalogConnectorContext.getMetalake().alterCatalog(catalogName, changes.toArray(changes.toArray(new CatalogChange[0])));
            this.catalogConnectorManager.loadMetalakeSync();
            catalogConnectorContext = this.catalogConnectorManager.getCatalogConnector(this.catalogConnectorManager.getTrinoCatalogName(this.metalake, catalogName));
            if (catalogConnectorContext == null || catalogConnectorContext.getCatalog().getLastModifiedTime() == oldCatalog.getLastModifiedTime()) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_OPERATION_FAILED, "Update catalog failed due to the reloading process fails");
            }
            LOG.info("Alter catalog {} in metalake {} successfully.", (Object)catalogName, (Object)this.metalake);
        }
        catch (NoSuchMetalakeException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_METALAKE_NOT_EXISTS, "Metalake " + this.metalake + " not exists.");
        }
        catch (NoSuchCatalogException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_NOT_EXISTS, "Catalog " + String.valueOf(NameIdentifier.of((String[])new String[]{this.metalake, catalogName})) + " not exists.");
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_OPERATION, "alter catalog failed. " + (StringUtils.isEmpty((CharSequence)e.getMessage()) ? "" : e.getMessage()), (Throwable)e);
        }
    }
}

