/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.ImmutableScanMetrics;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.Timer;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ScanMetrics {
    public static final String TOTAL_PLANNING_DURATION = "total-planning-duration";
    public static final String RESULT_DATA_FILES = "result-data-files";
    public static final String RESULT_DELETE_FILES = "result-delete-files";
    public static final String SCANNED_DATA_MANIFESTS = "scanned-data-manifests";
    public static final String SCANNED_DELETE_MANIFESTS = "scanned-delete-manifests";
    public static final String TOTAL_DATA_MANIFESTS = "total-data-manifests";
    public static final String TOTAL_DELETE_MANIFESTS = "total-delete-manifests";
    public static final String TOTAL_FILE_SIZE_IN_BYTES = "total-file-size-in-bytes";
    public static final String TOTAL_DELETE_FILE_SIZE_IN_BYTES = "total-delete-file-size-in-bytes";
    public static final String SKIPPED_DATA_MANIFESTS = "skipped-data-manifests";
    public static final String SKIPPED_DELETE_MANIFESTS = "skipped-delete-manifests";
    public static final String SKIPPED_DATA_FILES = "skipped-data-files";
    public static final String SKIPPED_DELETE_FILES = "skipped-delete-files";
    public static final String INDEXED_DELETE_FILES = "indexed-delete-files";
    public static final String EQUALITY_DELETE_FILES = "equality-delete-files";
    public static final String POSITIONAL_DELETE_FILES = "positional-delete-files";
    public static final String DVS = "dvs";

    public static ScanMetrics noop() {
        return ScanMetrics.of(MetricsContext.nullMetrics());
    }

    public abstract MetricsContext metricsContext();

    @Value.Derived
    public Timer totalPlanningDuration() {
        return this.metricsContext().timer(TOTAL_PLANNING_DURATION, TimeUnit.NANOSECONDS);
    }

    @Value.Derived
    public Counter resultDataFiles() {
        return this.metricsContext().counter(RESULT_DATA_FILES);
    }

    @Value.Derived
    public Counter resultDeleteFiles() {
        return this.metricsContext().counter(RESULT_DELETE_FILES);
    }

    @Value.Derived
    public Counter scannedDataManifests() {
        return this.metricsContext().counter(SCANNED_DATA_MANIFESTS);
    }

    @Value.Derived
    public Counter totalDataManifests() {
        return this.metricsContext().counter(TOTAL_DATA_MANIFESTS);
    }

    @Value.Derived
    public Counter totalDeleteManifests() {
        return this.metricsContext().counter(TOTAL_DELETE_MANIFESTS);
    }

    @Value.Derived
    public Counter totalFileSizeInBytes() {
        return this.metricsContext().counter(TOTAL_FILE_SIZE_IN_BYTES, MetricsContext.Unit.BYTES);
    }

    @Value.Derived
    public Counter totalDeleteFileSizeInBytes() {
        return this.metricsContext().counter(TOTAL_DELETE_FILE_SIZE_IN_BYTES, MetricsContext.Unit.BYTES);
    }

    @Value.Derived
    public Counter skippedDataManifests() {
        return this.metricsContext().counter(SKIPPED_DATA_MANIFESTS);
    }

    @Value.Derived
    public Counter skippedDataFiles() {
        return this.metricsContext().counter(SKIPPED_DATA_FILES);
    }

    @Value.Derived
    public Counter skippedDeleteFiles() {
        return this.metricsContext().counter(SKIPPED_DELETE_FILES);
    }

    @Value.Derived
    public Counter scannedDeleteManifests() {
        return this.metricsContext().counter(SCANNED_DELETE_MANIFESTS);
    }

    @Value.Derived
    public Counter skippedDeleteManifests() {
        return this.metricsContext().counter(SKIPPED_DELETE_MANIFESTS);
    }

    @Value.Derived
    public Counter indexedDeleteFiles() {
        return this.metricsContext().counter(INDEXED_DELETE_FILES);
    }

    @Value.Derived
    public Counter equalityDeleteFiles() {
        return this.metricsContext().counter(EQUALITY_DELETE_FILES);
    }

    @Value.Derived
    public Counter positionalDeleteFiles() {
        return this.metricsContext().counter(POSITIONAL_DELETE_FILES);
    }

    @Value.Derived
    public Counter dvs() {
        return this.metricsContext().counter(DVS);
    }

    public static ScanMetrics of(MetricsContext metricsContext) {
        return ImmutableScanMetrics.builder().metricsContext(metricsContext).build();
    }
}

