/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.utils;

import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergCatalogBackend;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.iceberg.common.ClosableHiveCatalog;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.authentication.AuthenticationConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveCatalogWithMetadataLocationSupport;
import org.apache.iceberg.inmemory.InMemoryCatalog;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.jdbc.JdbcCatalogWithMetadataLocationSupport;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.memory.MemoryCatalogWithMetadataLocationSupport;
import org.apache.iceberg.rest.RESTCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergCatalogUtil.class);

    private static InMemoryCatalog loadMemoryCatalog(IcebergConfig icebergConfig) {
        String icebergCatalogName = icebergConfig.getCatalogBackendName();
        MemoryCatalogWithMetadataLocationSupport memoryCatalog = new MemoryCatalogWithMetadataLocationSupport();
        Map<String, String> resultProperties = icebergConfig.getIcebergCatalogProperties();
        if (!resultProperties.containsKey("warehouse")) {
            resultProperties.put("warehouse", "/tmp");
        }
        memoryCatalog.initialize(icebergCatalogName, resultProperties);
        return memoryCatalog;
    }

    private static HiveCatalog loadHiveCatalog(IcebergConfig icebergConfig) {
        HiveCatalogWithMetadataLocationSupport hiveCatalog = new HiveCatalogWithMetadataLocationSupport();
        HdfsConfiguration hdfsConfiguration = new HdfsConfiguration();
        String icebergCatalogName = icebergConfig.getCatalogBackendName();
        Map<String, String> properties = icebergConfig.getIcebergCatalogProperties();
        properties.forEach((arg_0, arg_1) -> ((HdfsConfiguration)hdfsConfiguration).set(arg_0, arg_1));
        AuthenticationConfig authenticationConfig = new AuthenticationConfig(properties);
        if (authenticationConfig.isSimpleAuth()) {
            hiveCatalog.setConf((Configuration)hdfsConfiguration);
            ((ClosableHiveCatalog)hiveCatalog).initialize(icebergCatalogName, properties);
            return hiveCatalog;
        }
        if (authenticationConfig.isKerberosAuth()) {
            HashMap<String, String> resultProperties = new HashMap<String, String>(properties);
            resultProperties.put("client-pool-cache-keys", "USER_NAME");
            hdfsConfiguration.set("hadoop.security.authorization", "true");
            hdfsConfiguration.set("hadoop.security.authentication", "kerberos");
            hiveCatalog.setConf((Configuration)hdfsConfiguration);
            ((ClosableHiveCatalog)hiveCatalog).initialize(icebergCatalogName, resultProperties);
            return hiveCatalog;
        }
        throw new UnsupportedOperationException("Unsupported authentication method: " + authenticationConfig.getAuthType());
    }

    private static JdbcCatalog loadJdbcCatalog(IcebergConfig icebergConfig) {
        String driverClassName = icebergConfig.getJdbcDriver();
        String icebergCatalogName = icebergConfig.getCatalogBackendName();
        Map<String, String> properties = icebergConfig.getIcebergCatalogProperties();
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't load jdbc driver " + driverClassName);
        }
        JdbcCatalogWithMetadataLocationSupport jdbcCatalog = new JdbcCatalogWithMetadataLocationSupport((Boolean)icebergConfig.get(IcebergConfig.JDBC_INIT_TABLES));
        HdfsConfiguration hdfsConfiguration = new HdfsConfiguration();
        properties.forEach((arg_0, arg_1) -> ((HdfsConfiguration)hdfsConfiguration).set(arg_0, arg_1));
        jdbcCatalog.setConf(hdfsConfiguration);
        try {
            jdbcCatalog.initialize(icebergCatalogName, properties);
        }
        catch (UncheckedSQLException e) {
            if (e.getCause() instanceof SQLException && e.getCause().getMessage().contains("Access denied")) {
                throw new ConnectionFailedException((Throwable)e, e.getMessage(), new Object[0]);
            }
            throw e;
        }
        return jdbcCatalog;
    }

    private static Catalog loadRestCatalog(IcebergConfig icebergConfig) {
        String icebergCatalogName = icebergConfig.getCatalogBackendName();
        RESTCatalog restCatalog = new RESTCatalog();
        HdfsConfiguration hdfsConfiguration = new HdfsConfiguration();
        Map<String, String> properties = icebergConfig.getIcebergCatalogProperties();
        properties.forEach((arg_0, arg_1) -> ((HdfsConfiguration)hdfsConfiguration).set(arg_0, arg_1));
        restCatalog.setConf((Object)hdfsConfiguration);
        restCatalog.initialize(icebergCatalogName, properties);
        return restCatalog;
    }

    private static Catalog loadCustomCatalog(IcebergConfig icebergConfig) {
        String customCatalogName = icebergConfig.getCatalogBackendName();
        String className = (String)icebergConfig.get(IcebergConfig.CATALOG_BACKEND_IMPL);
        return CatalogUtil.loadCatalog((String)className, (String)customCatalogName, icebergConfig.getIcebergCatalogProperties(), (Object)new HdfsConfiguration());
    }

    @VisibleForTesting
    static Catalog loadCatalogBackend(String catalogType) {
        return IcebergCatalogUtil.loadCatalogBackend(IcebergCatalogBackend.valueOf((String)catalogType.toUpperCase(Locale.ROOT)), new IcebergConfig(Collections.emptyMap()));
    }

    public static Catalog loadCatalogBackend(IcebergCatalogBackend catalogBackend, IcebergConfig icebergConfig) {
        LOG.info("Load catalog backend of {}", (Object)catalogBackend);
        switch (catalogBackend) {
            case MEMORY: {
                return IcebergCatalogUtil.loadMemoryCatalog(icebergConfig);
            }
            case HIVE: {
                return IcebergCatalogUtil.loadHiveCatalog(icebergConfig);
            }
            case JDBC: {
                return IcebergCatalogUtil.loadJdbcCatalog(icebergConfig);
            }
            case REST: {
                return IcebergCatalogUtil.loadRestCatalog(icebergConfig);
            }
            case CUSTOM: {
                return IcebergCatalogUtil.loadCustomCatalog(icebergConfig);
            }
        }
        throw new RuntimeException(String.valueOf(catalogBackend) + " catalog is not supported yet, supported catalogs: [memory]" + String.valueOf(catalogBackend));
    }

    private IcebergCatalogUtil() {
    }
}

