/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.iceberg;

import com.google.common.collect.Sets;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergPropertiesUtils;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogPropertyConverter;

public class IcebergCatalogPropertyConverter
extends CatalogPropertyConverter {
    private static final Set<String> JDBC_BACKEND_REQUIRED_PROPERTIES = Set.of("jdbc-driver", "uri", "jdbc-user", "jdbc-password");
    private static final Set<String> HIVE_BACKEND_REQUIRED_PROPERTIES = Set.of("uri");
    private static final Set<String> REST_BACKEND_REQUIRED_PROPERTIES = Set.of("uri");

    @Override
    public Map<String, String> gravitinoToEngineProperties(Map<String, String> properties) {
        String backend = properties.get("catalog-backend");
        if (backend == null) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_REQUIRED_PROPERTY, "Missing required property 'catalog-backend'");
        }
        Map<String, String> stringStringMap = switch (backend) {
            case "hive" -> this.buildHiveBackendProperties(properties);
            case "jdbc" -> this.buildJDBCBackendProperties(properties);
            case "rest" -> this.buildRestBackendProperties(properties);
            default -> throw new UnsupportedOperationException("Unsupported backend type: " + backend);
        };
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(super.gravitinoToEngineProperties(properties));
        config.putAll(stringStringMap);
        return config;
    }

    private Map<String, String> buildHiveBackendProperties(Map<String, String> properties) {
        Sets.SetView missingProperty = Sets.difference(HIVE_BACKEND_REQUIRED_PROPERTIES, properties.keySet());
        if (!missingProperty.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_REQUIRED_PROPERTY, "Missing required property for Hive backend: " + String.valueOf(missingProperty));
        }
        HashMap<String, String> hiveProperties = new HashMap<String, String>();
        hiveProperties.put("iceberg.catalog.type", "hive_metastore");
        hiveProperties.put("hive.metastore.uri", properties.get("uri"));
        return hiveProperties;
    }

    private Map<String, String> buildJDBCBackendProperties(Map<String, String> properties) {
        Sets.SetView missingProperty = Sets.difference(JDBC_BACKEND_REQUIRED_PROPERTIES, properties.keySet());
        if (!missingProperty.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_REQUIRED_PROPERTY, "Missing required property for JDBC backend: " + String.valueOf(missingProperty));
        }
        HashMap<String, String> jdbcProperties = new HashMap<String, String>();
        jdbcProperties.put("iceberg.catalog.type", "jdbc");
        jdbcProperties.put("iceberg.jdbc-catalog.driver-class", properties.get("jdbc-driver"));
        jdbcProperties.put("iceberg.jdbc-catalog.connection-url", properties.get("uri"));
        jdbcProperties.put("iceberg.jdbc-catalog.connection-user", properties.get("jdbc-user"));
        jdbcProperties.put("iceberg.jdbc-catalog.connection-password", properties.get("jdbc-password"));
        jdbcProperties.put("iceberg.jdbc-catalog.default-warehouse-dir", properties.get("warehouse"));
        jdbcProperties.put("iceberg.jdbc-catalog.catalog-name", IcebergPropertiesUtils.getCatalogBackendName(properties));
        return jdbcProperties;
    }

    private Map<String, String> buildRestBackendProperties(Map<String, String> properties) {
        Sets.SetView missingProperty = Sets.difference(REST_BACKEND_REQUIRED_PROPERTIES, properties.keySet());
        if (!missingProperty.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_REQUIRED_PROPERTY, "Missing required property for Rest backend: " + String.valueOf(missingProperty));
        }
        HashMap<String, String> jdbcProperties = new HashMap<String, String>();
        jdbcProperties.put("iceberg.catalog.type", "rest");
        jdbcProperties.put("iceberg.rest-catalog.uri", properties.get("uri"));
        return jdbcProperties;
    }
}

