/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import org.apache.gravitino.dto.file.FilesetDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class FilesetResponse
extends BaseResponse {
    @JsonProperty(value="fileset")
    private final FilesetDTO fileset;

    public FilesetResponse() {
        super(0);
        this.fileset = null;
    }

    public FilesetResponse(FilesetDTO fileset) {
        super(0);
        this.fileset = fileset;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.fileset != null, "fileset must not be null");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.fileset.name()), "fileset 'name' must not be null and empty");
        Preconditions.checkArgument(this.fileset.type() != null, "fileset 'type' must not be null and empty");
        Preconditions.checkArgument(this.fileset.storageLocations() != null, "fileset 'storageLocations' must not be null");
        Preconditions.checkArgument(!this.fileset.storageLocations().isEmpty(), "fileset 'storageLocations' must not be empty. At least one location is required.");
    }

    public FilesetDTO getFileset() {
        return this.fileset;
    }

    @Override
    public String toString() {
        return "FilesetResponse(fileset=" + String.valueOf(this.getFileset()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesetResponse)) {
            return false;
        }
        FilesetResponse other = (FilesetResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilesetDTO this$fileset = this.getFileset();
        FilesetDTO other$fileset = other.getFileset();
        return !(this$fileset == null ? other$fileset != null : !((Object)this$fileset).equals(other$fileset));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FilesetResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FilesetDTO $fileset = this.getFileset();
        result = result * 59 + ($fileset == null ? 43 : ((Object)$fileset).hashCode());
        return result;
    }
}

