/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.UpdateViewProperties;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;

class PropertiesUpdate
implements UpdateViewProperties {
    private final ViewOperations ops;
    private final Map<String, String> updates = Maps.newHashMap();
    private final Set<String> removals = Sets.newHashSet();
    private ViewMetadata base;

    PropertiesUpdate(ViewOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    public Map<String, String> apply() {
        return this.internalApply().properties();
    }

    private ViewMetadata internalApply() {
        this.base = this.ops.refresh();
        return ViewMetadata.buildFrom(this.base).setProperties(this.updates).removeProperties(this.removals).build();
    }

    public void commit() {
        Tasks.foreach(this.ops).retry(PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.num-retries", 4)).exponentialBackoff(PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.min-wait-ms", 100), PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.max-wait-ms", 60000), PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> taskOps.commit(this.base, this.internalApply()));
    }

    public UpdateViewProperties set(String key, String value) {
        Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Invalid key: null");
        Preconditions.checkArgument((null != value ? 1 : 0) != 0, (Object)"Invalid value: null");
        Preconditions.checkArgument((!this.removals.contains(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        this.updates.put(key, value);
        return this;
    }

    public UpdateViewProperties remove(String key) {
        Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Invalid key: null");
        Preconditions.checkArgument((!this.updates.containsKey(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        this.removals.add(key);
        return this;
    }
}

