/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitioning;

import java.util.Arrays;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.PartitionUtils;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.dto.rel.partitions.RangePartitionDTO;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;

public final class RangePartitioningDTO
implements Partitioning {
    private final String[] fieldName;
    private final RangePartitionDTO[] assignments;

    public static RangePartitioningDTO of(String[] fieldName) {
        return RangePartitioningDTO.of(fieldName, new RangePartitionDTO[0]);
    }

    public static RangePartitioningDTO of(String[] fieldName, RangePartitionDTO[] assignments) {
        return new RangePartitioningDTO(fieldName, assignments);
    }

    private RangePartitioningDTO(String[] fieldName, RangePartitionDTO[] assignments) {
        this.fieldName = fieldName;
        this.assignments = assignments;
    }

    public String[] fieldName() {
        return this.fieldName;
    }

    public String name() {
        return this.strategy().name().toLowerCase();
    }

    public RangePartitionDTO[] assignments() {
        return this.assignments;
    }

    public Expression[] arguments() {
        return new Expression[]{NamedReference.field((String[])this.fieldName)};
    }

    @Override
    public Partitioning.Strategy strategy() {
        return Partitioning.Strategy.RANGE;
    }

    @Override
    public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
        PartitionUtils.validateFieldExistence(columns, this.fieldName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangePartitioningDTO)) {
            return false;
        }
        RangePartitioningDTO other = (RangePartitioningDTO)o;
        if (!Arrays.deepEquals(this.fieldName, other.fieldName)) {
            return false;
        }
        return Arrays.deepEquals(this.assignments, other.assignments);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.fieldName);
        result = result * 59 + Arrays.deepHashCode(this.assignments);
        return result;
    }
}

