/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.gs.GSFileSystemOptions;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.utils.BlobUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSCommitRecoverable
implements RecoverableWriter.CommitRecoverable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSCommitRecoverable.class);
    public final GSBlobIdentifier finalBlobIdentifier;
    public final List<UUID> componentObjectIds;

    GSCommitRecoverable(GSBlobIdentifier finalBlobIdentifier, List<UUID> componentObjectIds) {
        LOGGER.trace("Creating GSCommitRecoverable for blob {} and componentObjectIds={}", (Object)finalBlobIdentifier, componentObjectIds);
        this.finalBlobIdentifier = (GSBlobIdentifier)Preconditions.checkNotNull((Object)finalBlobIdentifier);
        this.componentObjectIds = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(componentObjectIds)));
    }

    List<GSBlobIdentifier> getComponentBlobIds(GSFileSystemOptions options) {
        String temporaryBucketName = BlobUtils.getTemporaryBucketName(this.finalBlobIdentifier, options);
        List<GSBlobIdentifier> componentBlobIdentifiers = this.componentObjectIds.stream().map(temporaryObjectId -> options.isFileSinkEntropyEnabled() != false ? BlobUtils.getTemporaryObjectNameWithEntropy(this.finalBlobIdentifier, temporaryObjectId) : BlobUtils.getTemporaryObjectName(this.finalBlobIdentifier, temporaryObjectId)).map(temporaryObjectName -> new GSBlobIdentifier(temporaryBucketName, (String)temporaryObjectName)).collect(Collectors.toList());
        LOGGER.trace("Resolved component blob identifiers for blob {}: {}", (Object)this.finalBlobIdentifier, componentBlobIdentifiers);
        return componentBlobIdentifiers;
    }

    public String toString() {
        return "GSCommitRecoverable{finalBlobIdentifier=" + this.finalBlobIdentifier + ", componentObjectIds=" + this.componentObjectIds + "}";
    }
}

