/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@JsonTypeName(value="SessionWindow")
public class SessionWindowSpec
implements WindowSpec {
    public static final String FIELD_NAME_GAP = "gap";
    public static final String FIELD_NAME_PARTITION_KEYS = "partition_key_indices";
    @JsonProperty(value="gap")
    private final Duration gap;
    @JsonProperty(value="partition_key_indices")
    private final int[] partitionKeyIndices;

    @JsonCreator
    public SessionWindowSpec(@JsonProperty(value="gap") Duration gap, @JsonProperty(value="partition_key_indices") int[] partitionKeyIndices) {
        this.gap = (Duration)Preconditions.checkNotNull((Object)gap);
        this.partitionKeyIndices = (int[])Preconditions.checkNotNull((Object)partitionKeyIndices);
    }

    @Override
    public String toSummaryString(String windowing, String[] inputFieldNames) {
        if (this.partitionKeyIndices.length == 0) {
            return String.format("SESSION(%s, gap=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.gap));
        }
        Object[] partitionKeyNames = (String[])IntStream.of(this.partitionKeyIndices).mapToObj(idx -> inputFieldNames[idx]).toArray(String[]::new);
        return String.format("SESSION(%s, gap=[%s], partition keys=%s)", windowing, TimeUtils.formatWithHighestUnit((Duration)this.gap), Arrays.toString(partitionKeyNames));
    }

    public Duration getGap() {
        return this.gap;
    }

    public int[] getPartitionKeyIndices() {
        return this.partitionKeyIndices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionWindowSpec that = (SessionWindowSpec)o;
        return Objects.equals(this.gap, that.gap) && Arrays.equals(this.partitionKeyIndices, that.partitionKeyIndices);
    }

    public int hashCode() {
        return Objects.hash(SessionWindowSpec.class, this.gap, Arrays.hashCode(this.partitionKeyIndices));
    }

    public String toString() {
        return String.format("SESSION(gap=[%s],partitionKeys=%s)", TimeUtils.formatWithHighestUnit((Duration)this.gap), Arrays.toString(this.partitionKeyIndices));
    }

    @Override
    public boolean isAlignedWindow() {
        return false;
    }
}

