/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.TableRuntimeException;
import org.apache.flink.table.data.utils.CastExecutor;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.functions.casting.AbstractCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

abstract class AbstractCodeGeneratorCastRule<IN, OUT>
extends AbstractCastRule<IN, OUT>
implements CodeGeneratorCastRule<IN, OUT> {
    protected AbstractCodeGeneratorCastRule(CastRulePredicate predicate) {
        super(predicate);
    }

    @Override
    public CastExecutor<IN, OUT> create(CastRule.Context castRuleContext, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        String inputTerm = "_myInput";
        String inputIsNullTerm = "_myInputIsNull";
        String inputTypeTerm = CodeGenUtils.boxedTypeTermForType(inputLogicalType);
        CastExecutorCodeGeneratorContext ctx = new CastExecutorCodeGeneratorContext(castRuleContext);
        CodeGeneratorContext codeGeneratorContext = castRuleContext.getCodeGeneratorContext();
        String castExecutorClassName = CodeGenUtils.newName(codeGeneratorContext, "GeneratedCastExecutor");
        CastCodeBlock codeBlock = this.generateCodeBlock(ctx, "_myInput", "_myInputIsNull", inputLogicalType, targetLogicalType);
        String classFieldDecls = Stream.concat(ctx.typeSerializers.values().stream().map(entry -> "private final " + CodeGenUtils.className(((TypeSerializer)entry.getValue()).getClass()) + " " + (String)entry.getKey() + ";"), ctx.getClassFields().stream()).collect(Collectors.joining("\n"));
        String constructorSignature = "public " + castExecutorClassName + "(" + ctx.typeSerializers.values().stream().map(entry -> CodeGenUtils.className(((TypeSerializer)entry.getValue()).getClass()) + " " + (String)entry.getKey()).collect(Collectors.joining(", ")) + ")";
        String constructorBody = ctx.getDeclaredTypeSerializers().stream().map(name -> "this." + name + " = " + name + ";\n").collect(Collectors.joining());
        String functionSignature = "@Override public Object cast(Object _myInputObj) throws " + CodeGenUtils.className(TableRuntimeException.class);
        CastRuleUtils.CodeWriter bodyWriter = new CastRuleUtils.CodeWriter();
        bodyWriter.declStmt(inputTypeTerm, "_myInput", CastRuleUtils.cast(inputTypeTerm, "_myInputObj"));
        bodyWriter.declStmt("boolean", "_myInputIsNull", "_myInputObj == null");
        ctx.variableDeclarationStatements.forEach(decl -> bodyWriter.appendBlock(decl + "\n"));
        if (this.canFail(inputLogicalType, targetLogicalType)) {
            bodyWriter.tryCatchStmt(tryWriter -> tryWriter.append(codeBlock).stmt("return " + codeBlock.getReturnTerm()), (exceptionTerm, catchWriter) -> catchWriter.throwStmt(CastRuleUtils.constructorCall(TableRuntimeException.class, CastRuleUtils.strLiteral("Error when casting " + inputLogicalType + " to " + targetLogicalType + "."), exceptionTerm)), codeGeneratorContext);
        } else {
            bodyWriter.append(codeBlock).stmt("return " + codeBlock.getReturnTerm());
        }
        String classCode = "public final class " + castExecutorClassName + " implements " + CodeGenUtils.className(CastExecutor.class) + " {\n" + classFieldDecls + "\n" + constructorSignature + " {\n" + constructorBody + "}\n" + functionSignature + " {\n" + bodyWriter + "}\n}";
        try {
            Object[] constructorArgs = ctx.getTypeSerializersInstances().toArray(new TypeSerializer[0]);
            return (CastExecutor)CompileUtils.compile((ClassLoader)castRuleContext.getClassLoader(), (String)castExecutorClassName, (String)classCode).getConstructors()[0].newInstance(constructorArgs);
        }
        catch (Throwable e) {
            throw new FlinkRuntimeException("Cast executor cannot be instantiated. This is a bug. Please file an issue. Code:\n" + classCode, e);
        }
    }

    private static final class CastExecutorCodeGeneratorContext
    implements CodeGeneratorCastRule.Context {
        private final CastRule.Context castRuleCtx;
        private final Map<LogicalType, Map.Entry<String, TypeSerializer<?>>> typeSerializers = new LinkedHashMap();
        private final List<String> variableDeclarationStatements = new ArrayList<String>();
        private final List<String> classFields = new ArrayList<String>();
        private int variableIndex = 0;

        private CastExecutorCodeGeneratorContext(CastRule.Context castRuleCtx) {
            this.castRuleCtx = castRuleCtx;
        }

        @Override
        public boolean isPrinting() {
            return this.castRuleCtx.isPrinting();
        }

        @Override
        public boolean legacyBehaviour() {
            return this.castRuleCtx.legacyBehaviour();
        }

        @Override
        public String getSessionTimeZoneTerm() {
            return "java.util.TimeZone.getTimeZone(\"" + this.castRuleCtx.getSessionZoneId().getId() + "\")";
        }

        @Override
        public String declareVariable(String type, String variablePrefix) {
            String variableName = variablePrefix + "$" + this.variableIndex;
            this.variableDeclarationStatements.add(type + " " + variableName + ";");
            ++this.variableIndex;
            return variableName;
        }

        @Override
        public String declareTypeSerializer(LogicalType type) {
            return (String)this.typeSerializers.computeIfAbsent(type, t -> {
                AbstractMap.SimpleImmutableEntry<CallSite, TypeSerializer> e = new AbstractMap.SimpleImmutableEntry<CallSite, TypeSerializer>((CallSite)((Object)("typeSerializer$" + this.variableIndex)), InternalSerializers.create((LogicalType)t));
                ++this.variableIndex;
                return e;
            }).getKey();
        }

        @Override
        public String declareClassField(String type, String name, String initialization) {
            this.classFields.add(type + " " + name + " = " + initialization + ";");
            return "this." + name;
        }

        @Override
        public CodeGeneratorContext getCodeGeneratorContext() {
            return this.castRuleCtx.getCodeGeneratorContext();
        }

        public List<String> getDeclaredTypeSerializers() {
            return this.typeSerializers.values().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        }

        public List<TypeSerializer<?>> getTypeSerializersInstances() {
            return this.typeSerializers.values().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        }

        public List<String> getClassFields() {
            return this.classFields;
        }
    }
}

