/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

@Internal
public final class IndexArgumentTypeStrategy
implements ArgumentTypeStrategy {
    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        DataType indexType = callContext.getArgumentDataTypes().get(argumentPos);
        if (indexType.getLogicalType().is(LogicalTypeFamily.INTEGER_NUMERIC)) {
            Optional<Number> literalVal;
            if (callContext.isArgumentLiteral(argumentPos) && (literalVal = callContext.getArgumentValue(argumentPos, Number.class)).isPresent() && literalVal.get().longValue() < 0L) {
                return callContext.fail(throwOnFailure, "Index must be an integer starting from '0', but was '%s'.", literalVal.get());
            }
            return Optional.of(indexType);
        }
        return callContext.fail(throwOnFailure, "Index can only be an INTEGER NUMERIC type.", new Object[0]);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.ofGroup(LogicalTypeFamily.INTEGER_NUMERIC);
    }
}

