/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.velocity.test;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.flex.forks.velocity.VelocityContext;
import org.apache.flex.forks.velocity.app.VelocityEngine;
import org.apache.flex.forks.velocity.context.Context;
import org.apache.flex.forks.velocity.runtime.RuntimeServices;
import org.apache.flex.forks.velocity.runtime.log.LogSystem;
import org.apache.flex.forks.velocity.test.TestClassloader;

public class ClassloaderChangeTest
extends TestCase
implements LogSystem {
    private VelocityEngine ve = null;
    private boolean sawCacheDump = false;
    private static String OUTPUT = "Hello From Foo";

    public ClassloaderChangeTest() {
        super("ClassloaderChangeTest");
        try {
            this.ve = new VelocityEngine();
            this.ve.setProperty("runtime.log.logsystem", this);
            this.ve.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup ClassloaderChnageTest : " + e);
            System.exit(1);
        }
    }

    public void init(RuntimeServices rs) {
    }

    public static Test suite() {
        return new ClassloaderChangeTest();
    }

    public void runTest() {
        this.sawCacheDump = false;
        try {
            VelocityContext vc = new VelocityContext();
            Object foo = null;
            TestClassloader cl = new TestClassloader();
            Class<?> fooclass = cl.loadClass("Foo");
            foo = fooclass.newInstance();
            vc.put("foo", foo);
            StringWriter writer = new StringWriter();
            this.ve.evaluate((Context)vc, (Writer)writer, "test", "$foo.doIt()");
            if (!writer.toString().equals(OUTPUT)) {
                ClassloaderChangeTest.fail((String)"Output from doIt() incorrect");
            }
            cl = new TestClassloader();
            fooclass = cl.loadClass("Foo");
            foo = fooclass.newInstance();
            vc.put("foo", foo);
            writer = new StringWriter();
            this.ve.evaluate((Context)vc, (Writer)writer, "test", "$foo.doIt()");
            if (!writer.toString().equals(OUTPUT)) {
                ClassloaderChangeTest.fail((String)"Output from doIt() incorrect");
            }
        }
        catch (Exception ee) {
            System.out.println("ClassloaderChangeTest : " + ee);
        }
        if (!this.sawCacheDump) {
            ClassloaderChangeTest.fail((String)"Didn't see introspector cache dump.");
        }
    }

    public void logVelocityMessage(int level, String message) {
        if (message.equals("Introspector : detected classloader change. Dumping cache.")) {
            this.sawCacheDump = true;
        }
    }
}

