/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.reflect;

import flex2.compiler.SymbolTable;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.as3.reflect.As3Class;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.util.QNameList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeTable {
    private SymbolTable symbolTable;

    public TypeTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public AbcClass getClass(String className) {
        return this.symbolTable.getClass(className);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    static String convertName(ReferenceValue typeref) {
        ObjectValue ns = (ObjectValue)typeref.namespaces.first();
        if (ns != null && ns.name.length() > 0) {
            StringBuilder value = new StringBuilder(ns.name.length() + 1 + typeref.name.length());
            value.append(ns.name).append(':').append(typeref.name);
            return value.toString();
        }
        return typeref.name;
    }

    public final Map<String, AbcClass> createClasses(ObjectList clsdefs, QNameList toplevelDefinitions) {
        HashMap<String, AbcClass> classes = new HashMap<String, AbcClass>();
        int size = clsdefs.size();
        for (int i = 0; i < size; ++i) {
            ClassDefinitionNode clsdef = (ClassDefinitionNode)clsdefs.get(i);
            QName qName = clsdef.cframe.builder.classname;
            if (!toplevelDefinitions.contains(qName.ns.name, qName.name)) continue;
            this.createClass(clsdef, classes);
        }
        return classes;
    }

    private final void createClass(ClassDefinitionNode clsdef, Map<String, AbcClass> classes) {
        As3Class cls = new As3Class(clsdef, this);
        classes.put(cls.getName(), cls);
    }

    static List<flex2.compiler.abc.MetaData> createMetaData(DefinitionNode def) {
        int size;
        ArrayList<MetaData> list = null;
        int n = size = def.metaData != null ? def.metaData.items.size() : 0;
        for (int i = 0; i < size; ++i) {
            MetaDataNode n2 = (MetaDataNode)def.metaData.items.get(i);
            if (list == null) {
                list = new ArrayList<MetaData>();
            }
            list.add(new MetaData(n2));
        }
        return list;
    }
}

