/*
 * Decompiled with CFR 0.152.
 */
package flex.ant.config;

import flex.ant.config.ConfigVariable;
import flex.ant.config.OptionSpec;
import org.apache.tools.ant.types.Commandline;

public final class ConfigBoolean
extends ConfigVariable {
    private boolean enabled;
    private boolean isSet;

    public ConfigBoolean(OptionSpec spec) {
        super(spec);
        this.enabled = false;
        this.isSet = false;
    }

    public ConfigBoolean(OptionSpec spec, boolean enabled) {
        super(spec);
        this.set(enabled);
    }

    public void set(boolean value) {
        this.enabled = value;
        this.isSet = true;
    }

    public void set(String value) {
        this.enabled = this.parseValue(value);
        this.isSet = true;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void addToCommandline(Commandline cmdl) {
        if (this.isSet) {
            cmdl.createArgument(true).setValue("-" + this.spec.getFullName() + "=" + this.enabled);
        }
    }

    private boolean parseValue(String value) {
        return value.toLowerCase().matches("\\s*(true|yes|on)\\s*");
    }
}

