/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.addaccrualtransactionforsavings;

import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.exception.MultiException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.savings.service.SavingsAccrualWritePlatformService;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class AddAccrualTransactionForSavingsTasklet
implements Tasklet {
    private final SavingsAccrualWritePlatformService savingsAccrualWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        try {
            this.addPeriodicAccruals(DateUtils.getBusinessLocalDate());
        }
        catch (MultiException e) {
            throw new JobExecutionException(e);
        }
        return RepeatStatus.FINISHED;
    }

    private void addPeriodicAccruals(LocalDate tilldate) throws MultiException {
        this.savingsAccrualWritePlatformService.addAccrualEntries(tilldate);
    }

    @Generated
    public AddAccrualTransactionForSavingsTasklet(SavingsAccrualWritePlatformService savingsAccrualWritePlatformService) {
        this.savingsAccrualWritePlatformService = savingsAccrualWritePlatformService;
    }
}

