/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.handler.loan.reaging;

import lombok.Generated;
import org.apache.fineract.commands.annotation.CommandType;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.DataIntegrityErrorHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.portfolio.loanaccount.service.reaging.LoanReAgingService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;

@Service
@CommandType(entity="LOAN", action="UNDO_REAGE")
public class LoanUndoReAgingCommandHandler
implements NewCommandSourceHandler {
    private final LoanReAgingService loanReAgingService;
    private final DataIntegrityErrorHandler dataIntegrityErrorHandler;

    public CommandProcessingResult processCommand(JsonCommand command) {
        try {
            return this.loanReAgingService.undoReAge(command.getLoanId(), command);
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.dataIntegrityErrorHandler.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve, "loan.undoReAge", "Error while handling undo re-age");
            return CommandProcessingResult.empty();
        }
    }

    @Generated
    public LoanUndoReAgingCommandHandler(LoanReAgingService loanReAgingService, DataIntegrityErrorHandler dataIntegrityErrorHandler) {
        this.loanReAgingService = loanReAgingService;
        this.dataIntegrityErrorHandler = dataIntegrityErrorHandler;
    }
}

