/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.sms.scheduler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.helper.SmsConfigUtils;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.campaigns.sms.exception.ConnectionFailureException;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.gcm.service.NotificationSenderService;
import org.apache.fineract.infrastructure.sms.data.SmsMessageApiQueueResourceData;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.apache.fineract.infrastructure.sms.scheduler.SmsMessageScheduledJobService;
import org.apache.fineract.infrastructure.sms.scheduler.SmsMessageScheduledJobServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SmsMessageScheduledJobServiceImpl
implements SmsMessageScheduledJobService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsMessageScheduledJobServiceImpl.class);
    private final SmsMessageRepository smsMessageRepository;
    private final RestTemplate restTemplate = new RestTemplate();
    private final SmsConfigUtils smsConfigUtils;
    private final NotificationSenderService notificationSenderService;
    @Qualifier(value="fineractDefaultThreadPoolTaskExecutor")
    private final ThreadPoolTaskExecutor taskExecutor;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    private void connectAndSendToIntermediateServer(Collection<SmsMessageApiQueueResourceData> apiQueueResourceDatas) {
        HttpEntity entity;
        Map hostConfig = this.smsConfigUtils.getMessageGateWayRequestURI("sms", SmsMessageApiQueueResourceData.toJsonString(apiQueueResourceDatas));
        URI uri = (URI)hostConfig.get("uri");
        ResponseEntity responseOne = this.restTemplate.exchange(uri, HttpMethod.POST, entity = (HttpEntity)hostConfig.get("entity"), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (responseOne != null && !responseOne.getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
            log.debug("{}", (Object)responseOne.getStatusCode().value());
            throw new ConnectionFailureException("sms");
        }
    }

    public void sendTriggeredMessages(Map<SmsCampaign, Collection<SmsMessage>> smsDataMap) {
        try {
            if (!smsDataMap.isEmpty()) {
                ArrayList<SmsMessage> toSaveMessages = new ArrayList<SmsMessage>();
                ArrayList<SmsMessage> toSendNotificationMessages = new ArrayList<SmsMessage>();
                for (Map.Entry<SmsCampaign, Collection<SmsMessage>> entry : smsDataMap.entrySet()) {
                    for (SmsMessage smsMessage : entry.getValue()) {
                        if (smsMessage.isNotification()) {
                            smsMessage.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
                            toSendNotificationMessages.add(smsMessage);
                            continue;
                        }
                        smsMessage.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
                        toSaveMessages.add(smsMessage);
                    }
                }
                if (!toSaveMessages.isEmpty()) {
                    this.smsMessageRepository.saveAll(toSaveMessages);
                    this.smsMessageRepository.flush();
                    for (Map.Entry<SmsCampaign, Collection<SmsMessage>> entry : smsDataMap.entrySet()) {
                        ArrayList<SmsMessageApiQueueResourceData> apiQueueResourceDatas = new ArrayList<SmsMessageApiQueueResourceData>();
                        for (SmsMessage smsMessage : entry.getValue()) {
                            if (smsMessage.isNotification()) continue;
                            SmsMessageApiQueueResourceData apiQueueResourceData = SmsMessageApiQueueResourceData.instance((Long)((Long)smsMessage.getId()), null, null, null, (String)smsMessage.getMobileNo(), (String)smsMessage.getMessage(), (Long)entry.getKey().getProviderId());
                            apiQueueResourceDatas.add(apiQueueResourceData);
                        }
                        if (apiQueueResourceDatas.isEmpty()) continue;
                        this.taskExecutor.execute((Runnable)new SmsTask(this, apiQueueResourceDatas, ThreadLocalContextUtil.getContext()));
                    }
                }
                if (!toSendNotificationMessages.isEmpty()) {
                    this.notificationSenderService.sendNotification(toSendNotificationMessages);
                }
            }
        }
        catch (Exception e) {
            log.error("Error occurred.", (Throwable)e);
        }
    }

    public void sendTriggeredMessage(Collection<SmsMessage> smsMessages, long providerId) {
        try {
            ArrayList<SmsMessageApiQueueResourceData> apiQueueResourceDatas = new ArrayList<SmsMessageApiQueueResourceData>();
            StringBuilder request = new StringBuilder();
            for (SmsMessage smsMessage : smsMessages) {
                SmsMessageApiQueueResourceData apiQueueResourceData = SmsMessageApiQueueResourceData.instance((Long)((Long)smsMessage.getId()), null, null, null, (String)smsMessage.getMobileNo(), (String)smsMessage.getMessage(), (Long)providerId);
                apiQueueResourceDatas.add(apiQueueResourceData);
                smsMessage.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
            }
            this.smsMessageRepository.saveAll(smsMessages);
            request.append(SmsMessageApiQueueResourceData.toJsonString(apiQueueResourceDatas));
            log.debug("Sending triggered SMS to specific provider with request - {}", (Object)request);
            this.taskExecutor.execute((Runnable)new SmsTask(this, apiQueueResourceDatas, ThreadLocalContextUtil.getContext()));
        }
        catch (Exception e) {
            log.error("Error occured.", (Throwable)e);
        }
    }

    @Generated
    public SmsMessageScheduledJobServiceImpl(SmsMessageRepository smsMessageRepository, SmsConfigUtils smsConfigUtils, NotificationSenderService notificationSenderService, @Qualifier(value="fineractDefaultThreadPoolTaskExecutor") ThreadPoolTaskExecutor taskExecutor) {
        this.smsMessageRepository = smsMessageRepository;
        this.smsConfigUtils = smsConfigUtils;
        this.notificationSenderService = notificationSenderService;
        this.taskExecutor = taskExecutor;
    }
}

