/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.service;

import java.util.Collection;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobConfigurationData;
import org.apache.fineract.infrastructure.reportmailingjob.exception.ReportMailingJobConfigurationNotFoundException;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobConfigurationReadPlatformService;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobConfigurationReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ReportMailingJobConfigurationReadPlatformServiceImpl
implements ReportMailingJobConfigurationReadPlatformService {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public ReportMailingJobConfigurationReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<ReportMailingJobConfigurationData> retrieveAllReportMailingJobConfigurations() {
        ReportMailingJobConfigurationMapper mapper = new ReportMailingJobConfigurationMapper();
        String sql = "select " + mapper.reportMailingJobConfigurationSchema();
        return this.jdbcTemplate.query(sql, (RowMapper)mapper);
    }

    public ReportMailingJobConfigurationData retrieveReportMailingJobConfiguration(String name) {
        try {
            ReportMailingJobConfigurationMapper mapper = new ReportMailingJobConfigurationMapper();
            String sql = "select " + mapper.reportMailingJobConfigurationSchema() + " where rmjc.name = ?";
            return (ReportMailingJobConfigurationData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{name});
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ReportMailingJobConfigurationNotFoundException(name, ex);
        }
    }
}

