/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.LoanTransactionDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanTransactionDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.AbstractBusinessEventWithCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.BusinessEventSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.ExternalEventCustomDataSerializer;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargePaidByReadService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class LoanTransactionBusinessEventSerializer
extends AbstractBusinessEventWithCustomDataSerializer<LoanTransactionBusinessEvent>
implements BusinessEventSerializer {
    private final LoanReadPlatformService service;
    private final LoanTransactionDataMapper loanTransactionMapper;
    private final LoanChargePaidByReadService loanChargePaidByReadService;
    private final List<ExternalEventCustomDataSerializer<LoanTransactionBusinessEvent>> externalEventCustomDataSerializers;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanTransactionBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanTransactionBusinessEvent event = (LoanTransactionBusinessEvent)rawEvent;
        Long loanId = (Long)((LoanTransaction)event.get()).getLoan().getId();
        Long loanTransactionId = (Long)((LoanTransaction)event.get()).getId();
        LoanTransactionData transactionData = this.service.retrieveLoanTransaction(loanId, loanTransactionId);
        transactionData.setLoanChargePaidByList((Collection)this.loanChargePaidByReadService.fetchLoanChargesPaidByDataTransactionId(loanTransactionId));
        LoanTransactionDataV1 result = this.loanTransactionMapper.map(transactionData);
        result.setCustomData(this.collectCustomData((BusinessEvent)event));
        return result;
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanTransactionDataV1.class;
    }

    protected List<ExternalEventCustomDataSerializer<LoanTransactionBusinessEvent>> getExternalEventCustomDataSerializers() {
        return this.externalEventCustomDataSerializers;
    }

    @Generated
    public LoanTransactionBusinessEventSerializer(LoanReadPlatformService service, LoanTransactionDataMapper loanTransactionMapper, LoanChargePaidByReadService loanChargePaidByReadService, List<ExternalEventCustomDataSerializer<LoanTransactionBusinessEvent>> externalEventCustomDataSerializers) {
        this.service = service;
        this.loanTransactionMapper = loanTransactionMapper;
        this.loanChargePaidByReadService = loanChargePaidByReadService;
        this.externalEventCustomDataSerializers = externalEventCustomDataSerializers;
    }
}

