/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.savings.data.SavingsProductData;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SavingsProductSheetPopulator
extends AbstractWorkbookPopulator {
    private List<SavingsProductData> savingsProducts;
    private static final int ID_COL = 0;
    private static final int NAME_COL = 1;
    private static final int NOMINAL_ANNUAL_INTEREST_RATE_COL = 2;
    private static final int INTEREST_COMPOUNDING_PERIOD_COL = 3;
    private static final int INTEREST_POSTING_PERIOD_COL = 4;
    private static final int INTEREST_CALCULATION_COL = 5;
    private static final int INTEREST_CALCULATION_DAYS_IN_YEAR_COL = 6;
    private static final int MIN_OPENING_BALANCE_COL = 7;
    private static final int LOCKIN_PERIOD_COL = 8;
    private static final int LOCKIN_PERIOD_FREQUENCY_COL = 9;
    private static final int CURRENCY_COL = 10;
    private static final int DECIMAL_PLACES_COL = 11;
    private static final int IN_MULTIPLES_OF_COL = 12;
    private static final int WITHDRAWAL_FEE_COL = 13;
    private static final int ALLOW_OVERDRAFT_COL = 14;
    private static final int OVERDRAFT_LIMIT_COL = 15;

    public SavingsProductSheetPopulator(List<SavingsProductData> savingsProducts) {
        this.savingsProducts = savingsProducts;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int rowIndex = 1;
        Sheet productSheet = workbook.createSheet("Products");
        this.setLayout(productSheet);
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        for (SavingsProductData product : this.savingsProducts) {
            Row row = productSheet.createRow(rowIndex++);
            this.writeLong(0, row, product.getId().longValue());
            this.writeString(1, row, product.getName().trim().replaceAll("[ )(]", "_"));
            this.writeBigDecimal(2, row, product.getNominalAnnualInterestRate());
            this.writeString(3, row, product.getInterestCompoundingPeriodType().getValue());
            this.writeString(4, row, product.getInterestPostingPeriodType().getValue());
            this.writeString(5, row, product.getInterestCalculationType().getValue());
            this.writeString(6, row, product.getInterestCalculationDaysInYearType().getValue());
            if (product.getMinRequiredOpeningBalance() != null) {
                this.writeBigDecimal(7, row, product.getMinRequiredOpeningBalance());
            }
            if (product.getLockinPeriodFrequency() != null) {
                this.writeInt(8, row, product.getLockinPeriodFrequency().intValue());
            }
            if (product.getLockinPeriodFrequencyType() != null) {
                this.writeString(9, row, product.getLockinPeriodFrequencyType().getValue());
            }
            CurrencyData currency = product.getCurrency();
            this.writeString(10, row, currency.getCode());
            this.writeInt(11, row, currency.getDecimalPlaces());
            if (currency.getInMultiplesOf() != null) {
                this.writeInt(12, row, currency.getInMultiplesOf().intValue());
            }
            this.writeBoolean(13, row, Boolean.valueOf(product.isWithdrawalFeeForTransfers()));
            this.writeBoolean(14, row, Boolean.valueOf(product.isAllowOverdraft()));
            if (product.getOverdraftLimit() == null) continue;
            this.writeBigDecimal(15, row, product.getOverdraftLimit());
        }
        productSheet.protectSheet("");
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 4000);
        this.writeString(0, rowHeader, "ID");
        this.writeString(1, rowHeader, "Name");
        this.writeString(2, rowHeader, "Interest");
        this.writeString(3, rowHeader, "Interest Compounding Period");
        this.writeString(4, rowHeader, "Interest Posting Period");
        this.writeString(5, rowHeader, "Interest Calculated Using");
        this.writeString(6, rowHeader, "# Days In Year");
        this.writeString(7, rowHeader, "Min Opening Balance");
        this.writeString(8, rowHeader, "Locked In For");
        this.writeString(9, rowHeader, "Frequency");
        this.writeString(10, rowHeader, "Currency");
        this.writeString(11, rowHeader, "Decimal Places");
        this.writeString(12, rowHeader, "In Multiples Of");
        this.writeString(13, rowHeader, "Withdrawal Fee for Transfers?");
        this.writeString(14, rowHeader, "Apply Overdraft");
        this.writeString(15, rowHeader, "Overdraft Limit");
    }

    public List<SavingsProductData> getProducts() {
        return this.savingsProducts;
    }

    public Integer getProductsSize() {
        return this.savingsProducts.size();
    }
}

