/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.savings.data.RecurringDepositProductData;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class RecurringDepositProductSheetPopulator
extends AbstractWorkbookPopulator {
    private List<RecurringDepositProductData> products;
    private static final int ID_COL = 0;
    private static final int NAME_COL = 1;
    private static final int SHORT_NAME_COL = 2;
    private static final int NOMINAL_ANNUAL_INTEREST_RATE_COL = 3;
    private static final int INTEREST_COMPOUNDING_PERIOD_COL = 4;
    private static final int INTEREST_POSTING_PERIOD_COL = 5;
    private static final int INTEREST_CALCULATION_COL = 6;
    private static final int INTEREST_CALCULATION_DAYS_IN_YEAR_COL = 7;
    private static final int LOCKIN_PERIOD_COL = 8;
    private static final int LOCKIN_PERIOD_FREQUENCY_COL = 9;
    private static final int CURRENCY_COL = 10;
    private static final int MIN_DEPOSIT_COL = 11;
    private static final int MAX_DEPOSIT_COL = 12;
    private static final int DEPOSIT_COL = 13;
    private static final int MIN_DEPOSIT_TERM_COL = 14;
    private static final int MIN_DEPOSIT_TERM_TYPE_COL = 15;
    private static final int MAX_DEPOSIT_TERM_COL = 16;
    private static final int MAX_DEPOSIT_TERM_TYPE_COL = 17;
    private static final int PRECLOSURE_PENAL_APPLICABLE_COL = 18;
    private static final int PRECLOSURE_PENAL_INTEREST_COL = 19;
    private static final int PRECLOSURE_INTEREST_TYPE_COL = 20;
    private static final int IN_MULTIPLES_OF_DEPOSIT_TERM_COL = 21;
    private static final int IN_MULTIPLES_OF_DEPOSIT_TERM_TYPE_COL = 22;
    private static final int IS_MANDATORY_DEPOSIT_COL = 23;
    private static final int ALLOW_WITHDRAWAL_COL = 24;
    private static final int ADJUST_ADVANCE_COL = 25;

    public RecurringDepositProductSheetPopulator(List<RecurringDepositProductData> recurringDepositProducts) {
        this.products = recurringDepositProducts;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int rowIndex = 1;
        Sheet productSheet = workbook.createSheet("Products");
        this.setLayout(productSheet);
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        for (RecurringDepositProductData product : this.products) {
            Row row = productSheet.createRow(rowIndex++);
            this.writeLong(0, row, product.getId().longValue());
            this.writeString(1, row, product.getName().trim().replaceAll("[ )(]", "_"));
            this.writeString(2, row, product.getShortName().trim().replaceAll("[ )(]", "_"));
            this.writeBigDecimal(3, row, product.getNominalAnnualInterestRate());
            this.writeString(4, row, product.getInterestCompoundingPeriodType().getValue());
            this.writeString(5, row, product.getInterestPostingPeriodType().getValue());
            this.writeString(6, row, product.getInterestCalculationType().getValue());
            this.writeString(7, row, product.getInterestCalculationDaysInYearType().getValue());
            this.writeBoolean(18, row, Boolean.valueOf(product.isPreClosurePenalApplicable()));
            this.writeString(15, row, product.getMinDepositTermType().getValue());
            if (product.getMinDepositAmount() != null) {
                this.writeBigDecimal(11, row, product.getMinDepositAmount());
            }
            if (product.getMaxDepositAmount() != null) {
                this.writeBigDecimal(12, row, product.getMaxDepositAmount());
            }
            if (product.getDepositAmount() != null) {
                this.writeBigDecimal(13, row, product.getDepositAmount());
            }
            if (product.getMaxDepositTerm() != null) {
                this.writeInt(16, row, product.getMaxDepositTerm().intValue());
            }
            if (product.getMinDepositTerm() != null) {
                this.writeInt(14, row, product.getMinDepositTerm().intValue());
            }
            if (product.getInMultiplesOfDepositTerm() != null) {
                this.writeInt(21, row, product.getInMultiplesOfDepositTerm().intValue());
            }
            if (product.getPreClosurePenalInterest() != null) {
                this.writeBigDecimal(19, row, product.getPreClosurePenalInterest());
            }
            if (product.getMaxDepositTermType() != null) {
                this.writeString(17, row, product.getMaxDepositTermType().getValue());
            }
            if (product.getPreClosurePenalInterestOnType() != null) {
                this.writeString(20, row, product.getPreClosurePenalInterestOnType().getValue());
            }
            if (product.getInMultiplesOfDepositTermType() != null) {
                this.writeString(22, row, product.getInMultiplesOfDepositTermType().getValue());
            }
            this.writeBoolean(24, row, Boolean.valueOf(product.isAllowWithdrawal()));
            this.writeBoolean(25, row, Boolean.valueOf(product.isAdjustAdvanceTowardsFuturePayments()));
            this.writeBoolean(23, row, Boolean.valueOf(product.isMandatoryDeposit()));
            if (product.getLockinPeriodFrequency() != null) {
                this.writeInt(8, row, product.getLockinPeriodFrequency().intValue());
            }
            if (product.getLockinPeriodFrequencyType() != null) {
                this.writeString(9, row, product.getLockinPeriodFrequencyType().getValue());
            }
            CurrencyData currency = product.getCurrency();
            this.writeString(10, row, currency.getCode());
        }
        productSheet.protectSheet("");
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(17, 4000);
        worksheet.setColumnWidth(18, 4000);
        worksheet.setColumnWidth(19, 4000);
        worksheet.setColumnWidth(20, 4000);
        worksheet.setColumnWidth(21, 4000);
        worksheet.setColumnWidth(22, 4000);
        worksheet.setColumnWidth(23, 4000);
        worksheet.setColumnWidth(24, 4000);
        worksheet.setColumnWidth(25, 4000);
        this.writeString(0, rowHeader, "ID");
        this.writeString(1, rowHeader, "Name");
        this.writeString(2, rowHeader, "Short Name");
        this.writeString(3, rowHeader, "Interest");
        this.writeString(4, rowHeader, "Interest Compounding Period");
        this.writeString(5, rowHeader, "Interest Posting Period");
        this.writeString(6, rowHeader, "Interest Calculated Using");
        this.writeString(7, rowHeader, "# Days In Year");
        this.writeString(8, rowHeader, "Locked In For");
        this.writeString(9, rowHeader, "Frequency");
        this.writeString(10, rowHeader, "Currency");
        this.writeString(11, rowHeader, "Min Deposit");
        this.writeString(12, rowHeader, "Max Deposit");
        this.writeString(13, rowHeader, "Deposit");
        this.writeString(14, rowHeader, "Min Deposit Term");
        this.writeString(16, rowHeader, "Max Deposit Term");
        this.writeString(15, rowHeader, "Min Deposit Term Type");
        this.writeString(17, rowHeader, "Max Deposit Term Type");
        this.writeString(18, rowHeader, "Preclosure Penal Applicable");
        this.writeString(19, rowHeader, "Penal Interest");
        this.writeString(20, rowHeader, "Penal Interest Type");
        this.writeString(21, rowHeader, "Multiples of Deposit Term");
        this.writeString(22, rowHeader, "Multiples of Deposit Term Type");
        this.writeString(23, rowHeader, "Is Mandatory Deposit?");
        this.writeString(24, rowHeader, "Allow Withdrawal?");
        this.writeString(25, rowHeader, "Adjust Advance Towards Future Payments?");
    }

    public List<RecurringDepositProductData> getProducts() {
        return this.products;
    }

    public Integer getProductsSize() {
        return this.products.size();
    }
}

