/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.staff;

import com.google.gson.GsonBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StaffImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StaffImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public StaffImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List staffList = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, staffList, dateFormat);
    }

    private List<StaffData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<StaffData> staffList = new ArrayList<StaffData>();
        Sheet staffSheet = workbook.getSheet("Employee");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)staffSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = staffSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)8)) continue;
            staffList.add(this.readStaff(workbook, row, locale, dateFormat));
        }
        return staffList;
    }

    private StaffData readStaff(Workbook workbook, Row row, String locale, String dateFormat) {
        String officeName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        Long officeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Offices"), (String)officeName);
        String firstName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        String lastName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        Boolean isLoanOfficer = ImportHandlerUtils.readAsBoolean((int)3, (Row)row);
        String mobileNo = null;
        if (ImportHandlerUtils.readAsLong((int)4, (Row)row) != null) {
            mobileNo = ImportHandlerUtils.readAsLong((int)4, (Row)row).toString();
        }
        LocalDate joinedOnDate = ImportHandlerUtils.readAsDate((int)5, (Row)row);
        String externalId = ImportHandlerUtils.readAsString((int)6, (Row)row);
        Boolean isActive = ImportHandlerUtils.readAsBoolean((int)7, (Row)row);
        return StaffData.importInstance((String)externalId, (String)firstName, (String)lastName, (String)mobileNo, (Long)officeId, (Boolean)isLoanOfficer, (Boolean)isActive, (LocalDate)joinedOnDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<StaffData> staffList, String dateFormat) {
        Sheet staffSheet = workbook.getSheet("Employee");
        int successCount = 0;
        int errorCount = 0;
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        for (StaffData staff : staffList) {
            try {
                String payload = gsonBuilder.create().toJson((Object)staff);
                CommandWrapper commandRequest = new CommandWrapperBuilder().createStaff().withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = staffSheet.getRow(staff.getRowIndex().intValue()).createCell(8);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)staffSheet, (Integer)staff.getRowIndex(), (String)errorMessage, (int)8);
            }
        }
        staffSheet.setColumnWidth(8, 4000);
        ImportHandlerUtils.writeString((int)8, (Row)staffSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

