/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.util;

import java.io.File;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Response;

public final class Parts {
    private Parts() {
    }

    public static MultipartBody.Part fromFile(File file) {
        RequestBody rb = RequestBody.create((File)file, (MediaType)Parts.mediaType(file.getName()));
        return MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)rb);
    }

    public static MultipartBody.Part fromBytes(String fileName, byte[] bytes) {
        RequestBody rb = RequestBody.create((byte[])bytes, (MediaType)Parts.mediaType(fileName));
        return MultipartBody.Part.createFormData((String)"file", (String)fileName, (RequestBody)rb);
    }

    static MediaType mediaType(String fileName) {
        String ext;
        if (fileName == null) {
            return null;
        }
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos == -1) {
            return null;
        }
        switch (ext = fileName.substring(dotPos + 1)) {
            case "jpg": 
            case "jpeg": {
                return MediaType.get((String)"image/jpeg");
            }
            case "png": {
                return MediaType.get((String)"image/png");
            }
            case "tif": 
            case "tiff": {
                return MediaType.get((String)"image/tiff");
            }
            case "gif": {
                return MediaType.get((String)"image/gif");
            }
            case "pdf": {
                return MediaType.get((String)"application/pdf");
            }
            case "docx": {
                return MediaType.get((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            }
            case "doc": {
                return MediaType.get((String)"application/msword");
            }
            case "xlsx": {
                return MediaType.get((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            }
            case "xls": {
                return MediaType.get((String)"application/vnd.ms-excel");
            }
            case "odt": {
                return MediaType.get((String)"application/vnd.oasis.opendocument.text");
            }
            case "ods": {
                return MediaType.get((String)"application/vnd.oasis.opendocument.spreadsheet");
            }
            case "txt": {
                return MediaType.get((String)"text/plain");
            }
        }
        return null;
    }

    public static Optional<String> fileName(Response<?> response) {
        String contentDisposition = response.headers().get("Content-Disposition");
        if (contentDisposition == null) {
            return Optional.empty();
        }
        int i = contentDisposition.indexOf("; filename=\"");
        if (i == -1) {
            return Optional.empty();
        }
        return Optional.of(contentDisposition.substring(i + "; filename=\"".length(), contentDisposition.length() - 1));
    }
}

