/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.CodeSource;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.daffodil.api.exceptions.InvalidParserException;
import org.apache.daffodil.core.compiler.Compiler$;
import org.apache.daffodil.core.compiler.ProcessorFactory;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.DaffodilSchemaSource;
import org.apache.daffodil.lib.iapi.DaffodilTunables;
import org.apache.daffodil.lib.iapi.DaffodilTunables$;
import org.apache.daffodil.lib.iapi.URISchemaSource;
import org.apache.daffodil.lib.iapi.URISchemaSource$;
import org.apache.daffodil.lib.iapi.UnitTestSchemaSource$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.dsom.SchemaDefinitionError;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Node;

public class Compiler
implements org.apache.daffodil.api.Compiler,
DFDL.Compiler {
    private final boolean validateDFDLSchemas;
    private final DaffodilTunables tunables;
    private final boolean checkAllTopLevel;
    private final Option optRootName;
    private final Option optRootNamespace;

    public static Compiler apply(boolean bl) {
        return Compiler$.MODULE$.apply(bl);
    }

    public static boolean apply$default$1() {
        return Compiler$.MODULE$.apply$default$1();
    }

    private Compiler(boolean validateDFDLSchemas, DaffodilTunables tunables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        this.validateDFDLSchemas = validateDFDLSchemas;
        this.tunables = tunables;
        this.checkAllTopLevel = checkAllTopLevel;
        this.optRootName = optRootName;
        this.optRootNamespace = optRootNamespace;
    }

    public boolean validateDFDLSchemas() {
        return this.validateDFDLSchemas;
    }

    public DaffodilTunables tunables() {
        return this.tunables;
    }

    private boolean checkAllTopLevel() {
        return this.checkAllTopLevel;
    }

    private Option<String> optRootName() {
        return this.optRootName;
    }

    private Option<String> optRootNamespace() {
        return this.optRootNamespace;
    }

    public Compiler(boolean validateDFDLSchemas) {
        this(validateDFDLSchemas, DaffodilTunables$.MODULE$.apply(), true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    private Compiler copy(boolean validateDFDLSchemas, DaffodilTunables tunables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        return new Compiler(validateDFDLSchemas, tunables, checkAllTopLevel, optRootName, optRootNamespace);
    }

    private boolean copy$default$1() {
        return this.validateDFDLSchemas();
    }

    private DaffodilTunables copy$default$2() {
        return this.tunables();
    }

    private boolean copy$default$3() {
        return this.checkAllTopLevel();
    }

    private Option<String> copy$default$4() {
        return this.optRootName();
    }

    private Option<String> copy$default$5() {
        return this.optRootNamespace();
    }

    public Compiler withDistinguishedRootNode(String name, String namespace) {
        if (name == null) {
            throw Assert$.MODULE$.usageError("name.ne(null)");
        }
        Option option = Option$.MODULE$.apply((Object)name);
        Option option2 = Option$.MODULE$.apply((Object)namespace);
        boolean bl = this.copy$default$1();
        DaffodilTunables daffodilTunables = this.copy$default$2();
        boolean bl2 = this.copy$default$3();
        return this.copy(bl, daffodilTunables, bl2, (Option<String>)option, (Option<String>)option2);
    }

    public Compiler withValidateDFDLSchemas(boolean value) {
        return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public Compiler withTunable(String tunable, String value) {
        DaffodilTunables daffodilTunables = this.tunables().withTunable(tunable, value);
        boolean bl = this.copy$default$1();
        boolean bl2 = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(bl, daffodilTunables, bl2, option, option2);
    }

    public Compiler withTunables(scala.collection.immutable.Map<String, String> tunablesArg) {
        DaffodilTunables daffodilTunables = this.tunables().withTunables(tunablesArg);
        boolean bl = this.copy$default$1();
        boolean bl2 = this.copy$default$3();
        Option<String> option = this.copy$default$4();
        Option<String> option2 = this.copy$default$5();
        return this.copy(bl, daffodilTunables, bl2, option, option2);
    }

    public Compiler withCheckAllTopLevel(boolean flag) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), flag, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public org.apache.daffodil.api.DataProcessor reload(File savedParser) {
        return this.reload(new FileInputStream(savedParser));
    }

    @Override
    public org.apache.daffodil.api.DataProcessor reload(ReadableByteChannel savedParser) {
        return this.reload(Channels.newInputStream(savedParser));
    }

    public org.apache.daffodil.api.DataProcessor reload(DaffodilSchemaSource schemaSource) {
        return this.reload(schemaSource.uriForLoading());
    }

    public org.apache.daffodil.api.DataProcessor reload(URI uri) {
        return this.reload(uri.toURL().openStream());
    }

    public DataProcessor reload(InputStream is) {
        DataProcessor dataProcessor;
        try {
            String savedVersion;
            String requiredDataPrefix = "DAFFODIL ";
            StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(requiredDataPrefix), (Function1 & Serializable)v1 -> {
                Compiler.reload$$anonfun$1(is, BoxesRunTime.unboxToChar((Object)v1));
                return BoxedUnit.UNIT;
            });
            ArrayBuffer ab = new ArrayBuffer();
            int n = -1;
            while ((n = is.read()) > 0) {
                ab.append((Object)BoxesRunTime.boxToByte((byte)((byte)n)));
            }
            if (n == -1) {
                throw new InvalidParserException("The saved parser is corrupted");
            }
            String curVersion = Misc$.MODULE$.getDaffodilVersion();
            String string = savedVersion = new String((byte[])ab.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), "utf-8");
            String string2 = curVersion;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidParserException("The saved parser is only compatible with Daffodil " + savedVersion + ". Current version is " + curVersion);
            }
            ObjectInputStream objInput = new ObjectInputStream(is){

                public Class resolveClass(ObjectStreamClass desc) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(desc.getName(), false, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = super.resolveClass(desc);
                    }
                    return clazz;
                }
            };
            Object dpObj = objInput.readObject();
            objInput.close();
            DataProcessor dp = (DataProcessor)dpObj;
            dp.ssrd().compileLayers();
            dataProcessor = dp;
        }
        catch (ZipException zipException) {
            throw new InvalidParserException("The saved parser is corrupted");
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new InvalidParserException("The saved parser is corrupted");
        }
        catch (InvalidClassException ex) {
            Class<?> cls = Class.forName(ex.classname);
            CodeSource src = cls.getProtectionDomain().getCodeSource();
            String dependencyStr = src != null ? new File(src.getLocation().getFile()).getName() : "a dependency";
            throw new InvalidParserException("The saved parser was created with a different version of " + dependencyStr + " with incompatible class: " + ex.classname);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassNotFoundException || throwable2 instanceof NoClassDefFoundError || throwable2 instanceof InvalidObjectException || throwable2 instanceof SchemaDefinitionError) {
                Throwable ex = throwable2;
                throw new InvalidParserException("The saved parser was created with a different set of dependencies containing a class no longer on the classpath: " + ex.getMessage());
            }
            throw throwable;
        }
        return dataProcessor;
    }

    public ProcessorFactory compileFile(File file, Option<String> optRootName, Option<String> optRootNamespace) {
        URISchemaSource source = URISchemaSource$.MODULE$.apply(file, file.toURI());
        return this.compileSource((DaffodilSchemaSource)source, (Option)optRootName, (Option)optRootNamespace);
    }

    public Option<String> compileFile$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileFile$default$3() {
        return None$.MODULE$;
    }

    @Override
    public ProcessorFactory compileSource(DaffodilSchemaSource schemaSource, Option<String> optRootName, Option<String> optRootNamespace) {
        return Compiler$.MODULE$.org$apache$daffodil$core$compiler$Compiler$$$compileSourceSynchronizer(this, schemaSource, optRootName, optRootNamespace);
    }

    @Override
    public Option<String> compileSource$default$2() {
        return None$.MODULE$;
    }

    @Override
    public Option<String> compileSource$default$3() {
        return None$.MODULE$;
    }

    public ProcessorFactory org$apache$daffodil$core$compiler$Compiler$$compileSourceInternal(DaffodilSchemaSource schemaSource, Option<String> optRootNameArg, Option<String> optRootNamespaceArg) {
        Option rootName = optRootNameArg.orElse(this::$anonfun$4);
        Option rootNamespace = optRootNamespaceArg.orElse(this::$anonfun$5);
        ProcessorFactory pf = new ProcessorFactory((Option<String>)rootName, (Option<String>)rootNamespace, schemaSource, this.validateDFDLSchemas(), this.checkAllTopLevel(), this.tunables());
        return pf;
    }

    public ProcessorFactory compileNode(Node xml, Option<File> optTmpDir, Option<String> optRootName, Option<String> optRootNamespace) {
        return this.compileSource((DaffodilSchemaSource)UnitTestSchemaSource$.MODULE$.apply(xml, "anon", optTmpDir), (Option)optRootName, (Option)optRootNamespace);
    }

    public Option<File> compileNode$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileNode$default$3() {
        return None$.MODULE$;
    }

    public Option<String> compileNode$default$4() {
        return None$.MODULE$;
    }

    public org.apache.daffodil.api.ProcessorFactory compileSource(URI uri, Option<String> optRootName, Option<String> optRootNamespace) {
        return this.compileSource((DaffodilSchemaSource)URISchemaSource$.MODULE$.apply(Misc$.MODULE$.uriToDiagnosticFile(uri), uri), (Option)optRootName, (Option)optRootNamespace);
    }

    public org.apache.daffodil.api.ProcessorFactory compileResource(String name, Option<String> optRootName, Option<String> optRootNamespace) {
        URI uri = Misc$.MODULE$.getRequiredResource(name);
        URISchemaSource source = URISchemaSource$.MODULE$.apply(new File(name), uri);
        return this.compileSource((DaffodilSchemaSource)source, (Option)optRootName, (Option)optRootNamespace);
    }

    @Override
    public org.apache.daffodil.api.ProcessorFactory compileFile(File schemaFile, String rootName, String rootNamespace) {
        return this.compileFile(schemaFile, (Option<String>)Option$.MODULE$.apply((Object)rootName), (Option<String>)Option$.MODULE$.apply((Object)rootNamespace));
    }

    @Override
    public org.apache.daffodil.api.ProcessorFactory compileSource(URI uri, String rootName, String rootNamespace) {
        return this.compileSource(uri, (Option<String>)Option$.MODULE$.apply((Object)rootName), (Option<String>)Option$.MODULE$.apply((Object)rootNamespace));
    }

    @Override
    public org.apache.daffodil.api.ProcessorFactory compileResource(String name, String rootName, String rootNamespace) {
        return this.compileResource(name, (Option<String>)Option$.MODULE$.apply((Object)rootName), (Option<String>)Option$.MODULE$.apply((Object)rootNamespace));
    }

    @Override
    public org.apache.daffodil.api.Compiler withTunables(Map<String, String> tunables) {
        return this.withTunables((scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(tunables).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final /* synthetic */ void reload$$anonfun$1(InputStream is$1, char c) {
        if (is$1.read() != c) {
            throw new InvalidParserException("The saved parser is only compatible with an older version of Daffodil");
        }
    }

    private final Option $anonfun$4() {
        return this.optRootName();
    }

    private final Option $anonfun$5() {
        return this.optRootNamespace();
    }
}

