/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.query.InputStreamMarker;
import net.sf.saxon.resource.EncodingDetector;
import net.sf.saxon.resource.ParsedContentType;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.resource.TypedStreamSource;
import net.sf.saxon.trans.XPathException;

public class StandardUnparsedTextResolver
implements UnparsedTextURIResolver {
    private boolean debug = false;

    public void setDebugging(boolean debug) {
        this.debug = debug;
    }

    @Override
    public Reader resolve(URI absoluteURI, String encoding, Configuration config) throws XPathException {
        Logger err = config.getLogger();
        if (this.debug) {
            err.info("unparsed-text(): processing " + absoluteURI);
            err.info("unparsed-text(): requested encoding = " + encoding);
        }
        if (!absoluteURI.isAbsolute()) {
            throw new XPathException("Resolved URI supplied to unparsed-text() is not absolute: " + absoluteURI.toString(), "FOUT1170");
        }
        ResourceRequest rr = new ResourceRequest();
        rr.uri = absoluteURI.toString();
        rr.nature = encoding == null ? "https://www.iana.org/assignments/media-types/application/binary" : "https://www.iana.org/assignments/media-types/text/plain";
        rr.purpose = ResourceRequest.ANY_PURPOSE;
        Source resolved = rr.resolve(config.getResourceResolver(), new DirectResourceResolver(config));
        if (resolved == null) {
            throw new XPathException("unparsed-text(): failed to resolve URI " + absoluteURI);
        }
        if (resolved instanceof SAXSource) {
            return StandardUnparsedTextResolver.getReaderFromSAXSource((SAXSource)resolved, encoding, config, this.debug);
        }
        if (resolved instanceof AugmentedSource && ((AugmentedSource)resolved).getContainedSource() instanceof SAXSource) {
            return StandardUnparsedTextResolver.getReaderFromSAXSource((SAXSource)((AugmentedSource)resolved).getContainedSource(), encoding, config, this.debug);
        }
        if (resolved instanceof StreamSource) {
            return StandardUnparsedTextResolver.getReaderFromStreamSource((StreamSource)resolved, encoding, config, this.debug);
        }
        throw new XPathException("Resolver for unparsed-text() returned non-StreamSource");
    }

    public static Reader getReaderFromSAXSource(SAXSource source, String encoding, Configuration config, boolean debug) throws XPathException {
        Logger err = config.getLogger();
        InputStream inputStream = null;
        if (source.getInputSource() != null) {
            inputStream = source.getInputSource().getByteStream();
        }
        if (inputStream == null) {
            Reader reader = source.getInputSource().getCharacterStream();
            if (reader != null) {
                return reader;
            }
            String systemId = source.getSystemId();
            if (systemId != null) {
                try {
                    return ResourceLoader.urlReader(config, systemId, encoding);
                }
                catch (IOException e) {
                    throw new XPathException("unparsed-text(): cannot retrieve " + systemId, e);
                }
            }
            throw new XPathException("unparsed-text(): resolver returned empty StreamSource");
        }
        return StandardUnparsedTextResolver.detectEncoding(inputStream, encoding, config, debug);
    }

    private static Reader detectEncoding(InputStream inputStream, String encoding, Configuration config, boolean debug) throws XPathException {
        try {
            if (encoding == null) {
                Logger err = config.getLogger();
                inputStream = InputStreamMarker.ensureMarkSupported(inputStream);
                encoding = EncodingDetector.inferStreamEncoding(inputStream, "utf-8", debug ? err : null);
                if (debug) {
                    err.info("unparsed-text(): inferred encoding = " + encoding);
                }
            }
        }
        catch (IOException e) {
            encoding = "UTF-8";
        }
        try {
            return ResourceLoader.getReaderFromStream(inputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException(e).withErrorCode("FOUT1200");
        }
    }

    public static Reader getReaderFromStreamSource(StreamSource source, String encoding, Configuration config, boolean debug) throws XPathException {
        Logger err = config.getLogger();
        InputStream inputStream = source.getInputStream();
        if (inputStream == null) {
            if (source.getReader() != null) {
                return source.getReader();
            }
            String systemId = source.getSystemId();
            if (systemId != null) {
                try {
                    return ResourceLoader.urlReader(config, systemId, encoding);
                }
                catch (IOException e) {
                    throw new XPathException("unparsed-text(): cannot retrieve " + systemId, e);
                }
            }
            throw new XPathException("unparsed-text(): resolver returned empty StreamSource");
        }
        String contentType = null;
        if (source instanceof TypedStreamSource) {
            contentType = ((TypedStreamSource)source).getContentType();
            if (contentType != null) {
                ParsedContentType parsedContentType = new ParsedContentType(contentType);
                String contentEncoding = parsedContentType.encoding;
                if (contentEncoding != null) {
                    encoding = contentEncoding;
                }
                if (encoding == null) {
                    try {
                        encoding = EncodingDetector.inferStreamEncoding(inputStream, "UTF-8", null);
                    }
                    catch (IOException e) {
                        throw new XPathException("Unable to infer encoding", e);
                    }
                }
            }
            if (encoding != null) {
                try {
                    return ResourceLoader.getReaderFromStream(inputStream, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new XPathException(e);
                }
            }
        }
        return StandardUnparsedTextResolver.detectEncoding(inputStream, encoding, config, debug);
    }

    private static InputStream openClasspathResource(Configuration config, String systemId) throws XPathException {
        return config.getClass().getClassLoader().getResourceAsStream(systemId.substring(10));
    }
}

