/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.ctakes.assertion.medfacts.cleartk.CuePhrase;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.temporary.assertion.AssertionCuePhraseAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Property Cue Finder", description="Reads assertion cue words from file and annotates them.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.BASE_TOKEN})
public class AlternateCuePhraseAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_INPUT_FILE = "INPUT_FILE";
    @ConfigurationParameter(name="INPUT_FILE", description="Directory containing cue phrase files", mandatory=false)
    private String inputFilename = "org/apache/ctakes/assertion/cue_words.txt";
    private HashMap<String, CuePhrase> cueWords = null;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        int[] lenCounts = new int[10];
        this.cueWords = new HashMap();
        InputStream is = null;
        try {
            is = FileLocator.getAsStream((String)this.inputFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String record = "";
            while ((record = br.readLine()) != null) {
                String[] cueTokens;
                String[] splitRecord = record.split("\\|");
                if (splitRecord.length == 0) continue;
                String cuePhrase = splitRecord[0];
                String cuePhraseCategory = "default_category";
                String cuePhraseFamily = "default_family";
                if (splitRecord.length >= 2) {
                    cuePhraseCategory = splitRecord[1];
                    cuePhraseFamily = splitRecord[2];
                    if (cuePhraseCategory == null || cuePhraseCategory.isEmpty()) {
                        cuePhraseCategory = "category__" + cuePhraseFamily;
                    }
                }
                if ((cueTokens = cuePhrase.split("\\s+")).length < 3) {
                    this.cueWords.put(cuePhrase, new CuePhrase(cuePhrase, cuePhraseCategory, cuePhraseFamily));
                }
                if (cueTokens.length >= lenCounts.length) continue;
                int n = cueTokens.length;
                lenCounts[n] = lenCounts[n] + 1;
            }
            is.close();
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        ArrayList tokens = new ArrayList(JCasUtil.select((JCas)jCas, BaseToken.class));
        String lastKey = null;
        BaseToken lastToken = null;
        for (int i = 0; i < tokens.size(); ++i) {
            String twoKey;
            BaseToken token = (BaseToken)tokens.get(i);
            String key = token.getCoveredText().toLowerCase();
            if (this.cueWords.containsKey(key)) {
                this.addCuePhrase(jCas, key, token.getBegin(), token.getEnd());
            }
            if (i > 0 && this.cueWords.containsKey(twoKey = lastKey + " " + key)) {
                this.addCuePhrase(jCas, twoKey, lastToken.getBegin(), token.getEnd());
            }
            lastToken = token;
            lastKey = key;
        }
    }

    private void addCuePhrase(JCas jCas, String key, int begin, int end) {
        CuePhrase cueWord = this.cueWords.get(key);
        AssertionCuePhraseAnnotation cuePhraseAnnotation = new AssertionCuePhraseAnnotation(jCas);
        cuePhraseAnnotation.setBegin(begin);
        cuePhraseAnnotation.setEnd(end);
        cuePhraseAnnotation.setCuePhrase(key);
        cuePhraseAnnotation.setCuePhraseCategory(cueWord.category);
        cuePhraseAnnotation.setCuePhraseAssertionFamily(cueWord.family);
        cuePhraseAnnotation.addToIndexes();
    }
}

