/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.ae;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.FSUtil;
import org.apache.ctakes.core.util.JCasUtil;
import org.apache.ctakes.core.util.ParamUtil;
import org.apache.ctakes.typesystem.type.textspan.DrugLookupWindowAnnotation;
import org.apache.ctakes.typesystem.type.textspan.LookupWindowAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Drug Copier", description="Copies data from an existing JCas into a new JCas.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.SECTION})
public class CopyDrugAnnotator
extends JCasAnnotator_ImplBase {
    private int iv_srcType;
    private int iv_segmentType = 0;
    public static final String PARAM_SEGMENTS_TO_SKIP = "sectionOverrideSet";
    private Set iv_skipSegmentsSet;
    private Constructor iv_destContr;
    private Map iv_getSetMap;

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        super.initialize(annotCtx);
        try {
            String className = (String)annotCtx.getConfigParameterValue("srcDrugObjClass");
            Class<?> srcClass = Class.forName(className);
            this.iv_srcType = JCasUtil.getType((String)className);
            className = (String)annotCtx.getConfigParameterValue("destDrugObjClass");
            Class<?> destClass = Class.forName(className);
            Class[] constrArgs = new Class[]{JCas.class};
            this.iv_destContr = destClass.getConstructor(constrArgs);
            this.iv_skipSegmentsSet = ParamUtil.getStringParameterValuesSet((String)PARAM_SEGMENTS_TO_SKIP, (UimaContext)annotCtx);
            Map m = ParamUtil.getStringParameterValuesMap((String)"dataDrugBindMap", (UimaContext)annotCtx, (String)"|");
            this.iv_getSetMap = new HashMap();
            for (String getterMethName : m.keySet()) {
                String setterMethName = (String)m.get(getterMethName);
                Method getterMeth = srcClass.getMethod(getterMethName, null);
                Class[] setterArgs = new Class[]{getterMeth.getReturnType()};
                Method setterMeth = destClass.getMethod(setterMethName, setterArgs);
                this.iv_getSetMap.put(getterMeth, setterMeth);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator srcObjItr = indexes.getAnnotationIndex(Segment.type).iterator();
        Segment segment = null;
        while (srcObjItr.hasNext()) {
            TOP srcObj = (TOP)srcObjItr.next();
            Object[] constrArgVals = new Object[]{jcas};
            try {
                TOP destObj = (TOP)this.iv_destContr.newInstance(constrArgVals);
                boolean okayToSkip = false;
                boolean segmentMissing = this.iv_skipSegmentsSet.isEmpty();
                if (!segmentMissing) {
                    Iterator getSkipSegs = this.iv_skipSegmentsSet.iterator();
                    segment = (Segment)srcObj;
                    while (getSkipSegs.hasNext() && !okayToSkip) {
                        if (!getSkipSegs.next().equals(segment.getId())) continue;
                        okayToSkip = true;
                    }
                }
                Iterator getterItr = this.iv_getSetMap.keySet().iterator();
                while (getterItr.hasNext() && (okayToSkip || segmentMissing)) {
                    Method getterMeth = (Method)getterItr.next();
                    Method setterMeth = (Method)this.iv_getSetMap.get(getterMeth);
                    Object val = getterMeth.invoke((Object)srcObj, (Object[])null);
                    Object[] setterArgs = new Object[]{val};
                    setterMeth.invoke((Object)destObj, setterArgs);
                }
                if (okayToSkip) {
                    destObj.addToIndexes();
                    continue;
                }
                FSIterator lookupWindows = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)LookupWindowAnnotation.type, (int)segment.getBegin(), (int)segment.getEnd());
                while (lookupWindows.hasNext()) {
                    LookupWindowAnnotation lookup = (LookupWindowAnnotation)lookupWindows.next();
                    DrugLookupWindowAnnotation drugLookup = new DrugLookupWindowAnnotation(jcas, lookup.getBegin(), lookup.getEnd());
                    drugLookup.addToIndexes();
                }
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }
}

