/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.panelstack;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.panelstack.PanelStack;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.util.CoreComponentUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class PanelStackRenderer
extends DomBasicRenderer {
    private static final String[] PASSTHRU_EXCLUDE = new String[]{"style"};
    private static final String[] PASSTHRU = ExtendedAttributeConstants.getAttributes(60, PASSTHRU_EXCLUDE);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element panelStackTable;
        PanelStackRenderer.validateParameters(facesContext, uiComponent, PanelStack.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            panelStackTable = domContext.createRootElement("table");
            PanelStackRenderer.setRootElementId(facesContext, panelStackTable, uiComponent);
            PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, PASSTHRU);
        }
        panelStackTable = (Element)domContext.getRootNode();
        DOMContext.removeChildren(panelStackTable);
        panelStackTable.setAttribute("class", ((PanelStack)uiComponent).getStyleClass());
        String style = ((PanelStack)uiComponent).getStyle();
        if (style != null && style.length() > 0) {
            panelStackTable.setAttribute("style", style);
        } else {
            panelStackTable.removeAttribute("style");
        }
        Element tr = domContext.createElement("tr");
        panelStackTable.appendChild(tr);
        tr.setAttribute("class", ((PanelStack)uiComponent).getRowClass());
        Element td = domContext.createElement("td");
        tr.appendChild(td);
        td.setAttribute("class", ((PanelStack)uiComponent).getColumnClass());
        domContext.setCursorParent(td);
        PanelStack panelStack = (PanelStack)uiComponent;
        String selectedPanel = panelStack.getSelectedPanel();
        UIComponent childToRender = null;
        if (selectedPanel == null) {
            if (panelStack.getChildCount() > 0) {
                childToRender = (UIComponent)panelStack.getChildren().get(0);
            }
        } else {
            childToRender = CoreComponentUtils.findComponent(selectedPanel, (UIComponent)panelStack);
            if (childToRender == null && panelStack.getChildCount() > 0) {
                childToRender = (UIComponent)panelStack.getChildren().get(0);
            }
        }
        if (childToRender != null) {
            CustomComponentUtils.renderChild(facesContext, childToRender);
        }
        domContext.stepOver();
        facesContext.getExternalContext().getRequestMap().put("PanelStack-lastPanel" + uiComponent.getClientId(facesContext), selectedPanel);
    }
}

