/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.parameter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.apache.uima.fit.descriptor.ConfigurationParameter;

public final class ParameterMapper {
    private static final Logger LOGGER = Logger.getLogger((String)"ParameterMapper");

    private ParameterMapper() {
    }

    public static Map<ConfigurationParameter, String> createParameterTypeMap(Class<?> pipeBitClass) {
        HashMap<ConfigurationParameter, String> parameterMap = new HashMap<ConfigurationParameter, String>();
        ArrayList inheritables = new ArrayList();
        Class<?>[] interfaces = pipeBitClass.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            inheritables.addAll(Arrays.asList(interfaces));
        }
        if (pipeBitClass.getSuperclass() != null) {
            inheritables.add(pipeBitClass.getSuperclass());
        }
        inheritables.stream().map(ParameterMapper::createParameterTypeMap).forEach(parameterMap::putAll);
        Field[] fields = pipeBitClass.getDeclaredFields();
        Arrays.stream(fields).filter(f -> f.getAnnotation(ConfigurationParameter.class) != null).forEach(f -> parameterMap.put(f.getAnnotation(ConfigurationParameter.class), f.getType().getSimpleName()));
        return parameterMap;
    }

    public static Map<ConfigurationParameter, String[]> createParameterDefaultsMap(Class<?> pipeBitClass) {
        HashMap<ConfigurationParameter, String[]> parameterMap = new HashMap<ConfigurationParameter, String[]>();
        ArrayList inheritables = new ArrayList();
        Class<?>[] interfaces = pipeBitClass.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            inheritables.addAll(Arrays.asList(interfaces));
        }
        if (pipeBitClass.getSuperclass() != null) {
            inheritables.add(pipeBitClass.getSuperclass());
        }
        inheritables.stream().map(ParameterMapper::createParameterDefaultsMap).forEach(parameterMap::putAll);
        Field[] fields = pipeBitClass.getDeclaredFields();
        Arrays.stream(fields).map(f -> f.getAnnotation(ConfigurationParameter.class)).filter(Objects::nonNull).forEach(cp -> parameterMap.put((ConfigurationParameter)cp, cp.defaultValue()));
        return parameterMap;
    }
}

